package com.biz.eisp.activiti.entity.activiti;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * 流程在运行过程中所产生的任务数据保存在此表中
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_ru_task")
public class ActRuTaskEntity implements java.io.Serializable {

	private String id;
	// 任务所处的执行流id
	private ActRuExecutionEntity actRuExecutionByExecutionId;
	// 对应流程定义数据的id
	private ActReProcdefEntity actReProcdef;
	// 对应的流程实例id
	private ActRuExecutionEntity actRuExecutionByProcInstId;
	// 数据版本号
	private Integer rev;
	// 任务名称，在流程文件中定义
	private String name;
	// 父任务id，子任务才会设置该字段的值
	private String parentTaskId;
	// 任务描述，在流程文件中配置
	private String description;
	// 任务定义的id值，在流程文件中定义
	private String taskDefKey;
	// 任务拥有人，没有做外键关联
	private String owner;
	// 被指派执行该任务的人，没有做外键关联
	private String assignee;
	// 任务委托状态，有等候中和已解决两种状态
	private String delegation;
	// 任务优先级，默认为50
	private Integer priority;
	// 任务创建时间
	private Timestamp createTime;
	// 任务预定日期
	private Timestamp dueDate;
	//
	private Integer suspensionState;
	private Set<ActRuIdentitylinkEntity> actRuIdentitylinks = new HashSet<ActRuIdentitylinkEntity>(0);

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	@Column(name = "id_", unique = true, nullable = false, length = 64)
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "execution_id_")
	public ActRuExecutionEntity getActRuExecutionByExecutionId() {
		return this.actRuExecutionByExecutionId;
	}

	public void setActRuExecutionByExecutionId(ActRuExecutionEntity actRuExecutionByExecutionId) {
		this.actRuExecutionByExecutionId = actRuExecutionByExecutionId;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "proc_def_id_")
	public ActReProcdefEntity getActReProcdef() {
		return this.actReProcdef;
	}

	public void setActReProcdef(ActReProcdefEntity actReProcdef) {
		this.actReProcdef = actReProcdef;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "proc_inst_id_")
	public ActRuExecutionEntity getActRuExecutionByProcInstId() {
		return this.actRuExecutionByProcInstId;
	}

	public void setActRuExecutionByProcInstId(ActRuExecutionEntity actRuExecutionByProcInstId) {
		this.actRuExecutionByProcInstId = actRuExecutionByProcInstId;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	@Column(name = "name_")
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "parent_task_id_", length = 64)
	public String getParentTaskId() {
		return this.parentTaskId;
	}

	public void setParentTaskId(String parentTaskId) {
		this.parentTaskId = parentTaskId;
	}

	@Column(name = "description_", length = 4000)
	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name = "task_def_key_")
	public String getTaskDefKey() {
		return this.taskDefKey;
	}

	public void setTaskDefKey(String taskDefKey) {
		this.taskDefKey = taskDefKey;
	}

	@Column(name = "owner_")
	public String getOwner() {
		return this.owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	@Column(name = "assignee_")
	public String getAssignee() {
		return this.assignee;
	}

	public void setAssignee(String assignee) {
		this.assignee = assignee;
	}

	@Column(name = "delegation_", length = 64)
	public String getDelegation() {
		return this.delegation;
	}

	public void setDelegation(String delegation) {
		this.delegation = delegation;
	}

	@Column(name = "priority_")
	public Integer getPriority() {
		return this.priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}

	@Column(name = "create_time_", length = 29)
	public Timestamp getCreateTime() {
		return this.createTime;
	}

	public void setCreateTime(Timestamp createTime) {
		this.createTime = createTime;
	}

	@Column(name = "due_date_", length = 29)
	public Timestamp getDueDate() {
		return this.dueDate;
	}

	public void setDueDate(Timestamp dueDate) {
		this.dueDate = dueDate;
	}

	@Column(name = "suspension_state_")
	public Integer getSuspensionState() {
		return this.suspensionState;
	}

	public void setSuspensionState(Integer suspensionState) {
		this.suspensionState = suspensionState;
	}

	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "actRuTask")
	public Set<ActRuIdentitylinkEntity> getActRuIdentitylinks() {
		return this.actRuIdentitylinks;
	}

	public void setActRuIdentitylinks(Set<ActRuIdentitylinkEntity> actRuIdentitylinks) {
		this.actRuIdentitylinks = actRuIdentitylinks;
	}

}
