package com.biz.eisp.activiti.entity.activiti;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * Activiti提供此表来存放流程中的参数，这类参数包括流程实例参数，执行流参数和任务参数。参数可以会有多种类型，因此该表有多个字段用来存放参数值。
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_ru_variable")
public class ActRuVariableEntity implements java.io.Serializable {
	private String id;
	// 该参数对应的执行id，可以为null
	private ActRuExecutionEntity actRuExecutionByExecutionId;
	// 该参数对应的流程实例id，可以为null
	private ActRuExecutionEntity actRuExecutionByProcInstId;
	// 如果参数值是序列化对象，那么可以将该对象作为资源保存到资源表中，该字段保存资源表中的数据id
	private ActGeBytearrayEntity actGeBytearray;
	// 数据版本号
	private Integer rev;
	// 参数类型，该字段值可以为boolean，bytes，serializable，date，double，interger，jpa-entity，long，null，short，string，这些字段均为Activiti提供，还可以通过自定义来扩展参数类型
	private String type;
	// 参数名称
	private String name;
	// 如果该参数是任务参数，就需要设置任务id
	private String taskId;
	// 参数类型为double，则值会保存到该字段中
	private Double double_;
	// 参数类型为long，则值会保存到该字段中
	private Long long_;
	// 用于保存文本类型的参数值
	private String text;
	// 与text_字段一样，用于保存文本类型的参数值
	private String text2;

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "execution_id_")
	public ActRuExecutionEntity getActRuExecutionByExecutionId() {
		return this.actRuExecutionByExecutionId;
	}

	public void setActRuExecutionByExecutionId(ActRuExecutionEntity actRuExecutionByExecutionId) {
		this.actRuExecutionByExecutionId = actRuExecutionByExecutionId;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "proc_inst_id_")
	public ActRuExecutionEntity getActRuExecutionByProcInstId() {
		return this.actRuExecutionByProcInstId;
	}

	public void setActRuExecutionByProcInstId(ActRuExecutionEntity actRuExecutionByProcInstId) {
		this.actRuExecutionByProcInstId = actRuExecutionByProcInstId;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "bytearray_id_")
	public ActGeBytearrayEntity getActGeBytearray() {
		return this.actGeBytearray;
	}

	public void setActGeBytearray(ActGeBytearrayEntity actGeBytearray) {
		this.actGeBytearray = actGeBytearray;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	@Column(name = "type_", nullable = false)
	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "name_", nullable = false)
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "task_id_", length = 64)
	public String getTaskId() {
		return this.taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	@Column(name = "double_", precision = 17, scale = 17)
	public Double getDouble_() {
		return this.double_;
	}

	public void setDouble_(Double double_) {
		this.double_ = double_;
	}

	@Column(name = "long_")
	public Long getLong_() {
		return this.long_;
	}

	public void setLong_(Long long_) {
		this.long_ = long_;
	}

	@Column(name = "text_", length = 4000)
	public String getText() {
		return this.text;
	}

	public void setText(String text) {
		this.text = text;
	}

	@Column(name = "text2_", length = 4000)
	public String getText2() {
		return this.text2;
	}

	public void setText2(String text2) {
		this.text2 = text2;
	}

}
