package com.biz.eisp.activiti.hideNode.controller;


import com.biz.eisp.activiti.hideNode.service.TaHideNodeService;
import com.biz.eisp.activiti.hideNode.vo.TaHideNodeVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Controller
@RequestMapping("/taHideNodeController")
public class TaHideNodeController extends BaseController{

    @Autowired
    private TaHideNodeService taHideNodeService;

    /**
     * 跳转-隐藏节点-配置页面
     * @return
     */
    @RequestMapping(value = "goTaHidenNodeConfigMain", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaHidenNodeConfigMain(TaHideNodeVo vo){
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/hidenode/taHideNodeConfigMain");

        List<TaHideNodeVo> listNo = taHideNodeService.findHideNodeList(vo,null);
        List<TaHideNodeVo> listHide = taHideNodeService.findHidedNodelist(vo,page);
        for (TaHideNodeVo taHideNodeVo : listNo) {
            for (TaHideNodeVo hideNodeVo : listHide) {
                String processNodeCode = taHideNodeVo.getProcessNodeCode();
                String toHiddenNodeCode = hideNodeVo.getToHiddenNodeCode();
                if(processNodeCode.equals(toHiddenNodeCode)){
                    taHideNodeVo.setIsChecked("1");
                }
            }
        }
        taHideNodeService.initCopy(vo,view);
        view.addObject("list",listNo);
        view.addObject("vo",vo);
        return view;
    }

    /**
     * 查询-待选择隐藏节点列表
     */
    @RequestMapping(value = "findHideNodeList", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findHideNodeList(TaHideNodeVo vo, HttpServletRequest request){
        Page page = new EuPage(request);
        List<TaHideNodeVo> list = taHideNodeService.findHideNodeList(vo,page);
        return new DataGrid(list,page);
    }

    /**
     * 查询-已经隐藏节点列表
     */
    @RequestMapping(value = "findHidedNodelist", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findHidedNodelist(TaHideNodeVo vo,HttpServletRequest request){
        Page page = new EuPage(request);
        List<TaHideNodeVo> list = taHideNodeService.findHidedNodelist(vo,page);
        return new DataGrid(list,page);
    }

    /**
     * 保存-配置
     */
    @RequestMapping(value = "saveHideNode", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveHideNode(TaHideNodeVo vo){
        AjaxJson aj = new AjaxJson();
        try{
            taHideNodeService.saveHideNode(vo);
        }catch(Exception e){
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        return aj;
    }

    /**
     * 删除-配置
     */
    @RequestMapping(value = "deleHideNode", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleHideNode(TaHideNodeVo vo){
        AjaxJson aj = new AjaxJson();
        try{
            taHideNodeService.deleHideNode(vo);
        }catch(Exception e){
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        
        return aj;
    }

    /**
     * 隐藏所有节点
     */
    @RequestMapping(value = "initAllNodeToHide", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson initAllNodeToHide(TaHideNodeVo vo){
        AjaxJson aj = new AjaxJson();
        try{
            taHideNodeService.initAllNodeToHide(vo);
        }catch(Exception e){
            e.printStackTrace();
            aj.setMsg(e.getMessage());
            aj.setSuccess(false);
        }
        return aj;
    }

    /**
     * 删除所有隐藏节点配置
     */
    @RequestMapping(value = "delAllNodeToHide", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson delAllNodeToHide(TaHideNodeVo vo){
        AjaxJson aj = new AjaxJson();
        try{
            taHideNodeService.delAllNodeToHide(vo);
        }catch(Exception e){
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        return aj;
    }

}
