package com.biz.eisp.activiti.hideNode.service;

import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.activiti.hideNode.vo.TaHideNodeVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

/**
 * 隐藏节点功能:service
 */
public interface TaHideNodeService extends BaseService {

    /**
     * 查询-待选择节点列表
     */
    public List<TaHideNodeVo> findHideNodeList(TaHideNodeVo vo, Page page);

    /**
     * 加载-该流程本节点对所有节点隐藏
     */
    public void initAllNodeToHide(TaHideNodeVo vo);

    /**
     * 删除-该流程节点隐藏的节点
     */
    public void delAllNodeToHide(TaHideNodeVo vo);

    /**
     * 查询-该流程节点已经隐藏的节点
     */
    public List<TaHideNodeVo> findHidedNodelist(TaHideNodeVo vo, Page page);

    /**
     * 保存-配置
     */
    public void saveHideNode(TaHideNodeVo vo);

    /**
     * 删除-配置
     */
    public void deleHideNode(TaHideNodeVo vo);

    /**
     * 查询-根据ProcessInstanceId+nodeCode 查询开放给我的节点
     */
    public List<TaProcessNodeVo> findOpenNode(String processInstanceId,String processNodeCode);

    public void initCopy(TaHideNodeVo vo, ModelAndView view);
}
