package com.biz.eisp.activiti.hideNode.service.impl;

import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.activiti.hideNode.service.TaHideNodeService;
import com.biz.eisp.activiti.runtime.service.TaApprovalLogExtendService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Service("taApprovalLogExtendService")
@Transactional
public class TaExtendService extends BaseServiceImpl implements TaApprovalLogExtendService {

    @Autowired
    private TaHideNodeService taHideNodeService;

    @Autowired
    private TaskService taskService;

    @Override
    public List<TaProcessApprovalLogVo> filterApproveContent(List<TaProcessApprovalLogVo> list, HttpServletRequest request,MyTaskVo myTaskVo) {

        //当前登录人的职位
        String positionCode = ResourceConfigUtils.getCurrPosition().getPositionCode();
        //有管理员的角色进来直接通过
        String tmRoleString = ResourceConfigUtils.getTmRoleString();
        String[] split = tmRoleString.split(",");
        for (String s : split) {
            if(s!=null && s.equals("admin")){
                return list;
            }
        }

        String processInstanceId = myTaskVo.getProcessInstanceId();
        String taskId = myTaskVo.getTaskId();
        
        if(StringUtils.isBlank(processInstanceId)){
            throw new BusinessException("比传参数为空,请检查");
        }
        
        //沟通Y,审批N
        String isCommunicate = myTaskVo.getIsCommunicate();
        if(StringUtils.isBlank(isCommunicate) || isCommunicate.equals("Y") || isCommunicate.equals("N")){

            Task task = null;
            //当前任务所处的节点
            if(StringUtil.isNotBlank(taskId)){
                task = taskService.createTaskQuery().taskId(taskId).singleResult();
            }

            if(task != null){
                if(StringUtils.isNotBlank(isCommunicate) && "Y".equals(isCommunicate)){//在流程中的沟通
                    String sqlC = "select " +
                                  " distinct hidden_node_code as processNodeCode from " +
                                  " ta_hide_node_config t " +
                                  " where t.process_instance_id = ? and is_communicate = 1";
                    List<TaProcessNodeVo> bySql = this.findBySql(TaProcessNodeVo.class, sqlC, processInstanceId);
                    List<TaProcessApprovalLogVo> taProcessApprovalLogVos = this.displayLog(list, bySql);
                    return taProcessApprovalLogVos;
                }else{//审批
                    String taskDefinitionKey = task.getTaskDefinitionKey();
                    //查询对我隐藏的节点
                    List<TaProcessNodeVo> hideNode = taHideNodeService.findOpenNode(processInstanceId, taskDefinitionKey);
                    List<TaProcessApprovalLogVo> taProcessApprovalLogVos = this.displayLog(list, hideNode);
                    return taProcessApprovalLogVos;
                }
            }else{
                String sql = "select distinct t.task_def_key_ as processNodeCode from ACT_HI_TASKINST t where t.proc_inst_id_ = ? and assignee_ = ? ";
                List<TaProcessNodeVo> bySql = this.findBySql(TaProcessNodeVo.class, sql, processInstanceId, positionCode);
                if(CollectionUtil.listNotEmptyNotSizeZero(bySql)){
                    String processNodeCode = bySql.get(0).getProcessNodeCode();//处于过流程的节点
                    //查询对我隐藏的节点
                    List<TaProcessNodeVo> hideNodes = taHideNodeService.findOpenNode(processInstanceId, processNodeCode);
                    List<TaProcessApprovalLogVo> taProcessApprovalLogVos = this.displayLog(list, hideNodes);
                    return taProcessApprovalLogVos;
                }else{
                    String sqlC = "select " +
                            " distinct hidden_node_code as processNodeCode from " +
                            " ta_hide_node_config t " +
                            " where t.process_instance_id = ? and is_communicate = 1";
                    List<TaProcessNodeVo> bySql1 = this.findBySql(TaProcessNodeVo.class, sqlC, processInstanceId);
                    List<TaProcessApprovalLogVo> taProcessApprovalLogVos = this.displayLog(list, bySql1);
                    return taProcessApprovalLogVos;
                }
            }
        }else if(isCommunicate.equals("C")){//抄送传阅
            //判断我是否处于过流程中
            String sql = "select distinct t.task_def_key_ as processNodeCode from ACT_HI_TASKINST t where t.proc_inst_id_ = ? and assignee_ = ? ";
            List<TaProcessNodeVo> bySql = this.findBySql(TaProcessNodeVo.class, sql, processInstanceId, positionCode);
            if(CollectionUtil.listNotEmptyNotSizeZero(bySql)){//当前查看人处于过流程节点中
                String processNodeCode = bySql.get(0).getProcessNodeCode();//处于过流程的节点
                //查询对我隐藏的节点
                List<TaProcessNodeVo> hideNodes = taHideNodeService.findOpenNode(processInstanceId, processNodeCode);
                List<TaProcessApprovalLogVo> taProcessApprovalLogVos = this.displayLog(list, hideNodes);
                return taProcessApprovalLogVos;
            }else{//没有处于过流程节点过
                //查询那些节点对抄送,传阅进行过隐藏意见的
                String sql3 = " select " +
                              " distinct hidden_node_code as processNodeCode from " +
                              " ta_hide_node_config t " +
                              " where t.process_instance_id = ? and is_copy_cir = 1 ";
                List<TaProcessNodeVo> hideNode = this.findBySql(TaProcessNodeVo.class, sql3, processInstanceId);
                List<TaProcessApprovalLogVo> taProcessApprovalLogVos = this.displayLog(list, hideNode);
                return taProcessApprovalLogVos;
            }
        }
        return list;
    }

    private List<TaProcessApprovalLogVo> displayLog(List<TaProcessApprovalLogVo> list,List<TaProcessNodeVo> hideNode){
        for (TaProcessApprovalLogVo taProcessApprovalLogVo : list) {
            for (TaProcessNodeVo taProcessNodeVo : hideNode) {
                //日志上面的节点
                String taskDefKey = taProcessApprovalLogVo.getTaskDefKey();
                if(StringUtils.isBlank(taskDefKey))continue;
                //对我隐藏的节点
                String hideCode = taProcessNodeVo.getProcessNodeCode();
                if (taskDefKey.equals(hideCode)) {
                    String content = taProcessApprovalLogVo.getContent();
                    if(StringUtils.isNotBlank(content)){
                        taProcessApprovalLogVo.setContent("意见隐藏");
                    }
                }
            }
        }
        return list;
    }
}
