package com.biz.eisp.activiti.hideNode.service.impl;

import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.activiti.hideNode.dao.TaHideNodeDao;
import com.biz.eisp.activiti.hideNode.entity.TaHideNodeEntity;
import com.biz.eisp.activiti.hideNode.service.TaHideNodeService;
import com.biz.eisp.activiti.hideNode.vo.TaHideNodeVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.ModelAndView;

import java.util.ArrayList;
import java.util.List;

/**
 * 隐藏节点:service:Impl
 */
@Service("taHideNodeService")
@Transactional
public class TaHideNodeServiceImpl extends BaseServiceImpl implements TaHideNodeService{

    @Autowired
    private TaHideNodeDao taHideNodeDao;

    @Autowired
    private TaskService taskService;

    @Override
    public List<TaHideNodeVo> findHideNodeList(TaHideNodeVo vo, Page page) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        this.validateNotNull(processInstanceId,taskId);
        String nodeCode = this.getNodeCode(taskId);
        vo.setHiddenNodeCode(nodeCode);
        return taHideNodeDao.findHideNodeList(vo,page);
    }

    @Override
    public List<TaHideNodeVo> findHidedNodelist(TaHideNodeVo vo, Page page) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        this.validateNotNull(processInstanceId,taskId);
        String taskDefinitionKey = this.getNodeCode(taskId);
        vo.setHiddenNodeCode(taskDefinitionKey);
        return taHideNodeDao.findHidedNodelist(vo,page);
    }

    @Override
    public void saveHideNode(TaHideNodeVo vo) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        String toHiddenNodeCodes = vo.getToHiddenNodeCodes();
        String toHiddenNodeNames = vo.getToHiddenNodeNames();
        String isCopyCir = vo.getIsCopyCir();
        String isCommunicate = vo.getIsCommunicate();

        this.validateNotNull(processInstanceId,taskId,isCopyCir);
        //当前节点
        String nodeCode = this.getNodeCode(taskId);

        String sql = "delete from ta_hide_node_config t where t.process_instance_id = ? and t.hidden_node_code = ?";
        this.executeSql(sql,processInstanceId,nodeCode);

        String[] nodes = toHiddenNodeCodes.split(",");
        String[] names = toHiddenNodeNames.split(",");
        if(nodes == null){
            TaHideNodeEntity entity = new TaHideNodeEntity();
            entity.setProcessInstanceId(processInstanceId);
            entity.setHiddenNodeCode(nodeCode);
            entity.setHiddenNodeName(this.getNodeName(nodeCode,processInstanceId));
            entity.setIsCopyCir(isCopyCir);
            entity.setIsCommunicate(isCommunicate);
            this.save(entity);
        }else {
            for (int i = 0; i < nodes.length; i++) {
                TaHideNodeEntity entity = new TaHideNodeEntity();
                entity.setProcessInstanceId(processInstanceId);
                entity.setHiddenNodeCode(nodeCode);
                entity.setHiddenNodeName(this.getNodeName(nodeCode, processInstanceId));
                entity.setToHiddenNodeCode(nodes[i]);
                entity.setToHiddenNodeName(names[i]);
                entity.setIsCopyCir(isCopyCir);
                entity.setIsCommunicate(isCommunicate);
                this.save(entity);
            }
        }
        
        
    }

    @Override
    public void deleHideNode(TaHideNodeVo vo) {
        String processInstanceId = vo.getProcessInstanceId();
        String hiddenNodeCode = vo.getHiddenNodeCode();
        String toHiddenNodeCodes = vo.getToHiddenNodeCodes();
        this.validateNotNull(processInstanceId,toHiddenNodeCodes);
        String s = StringUtil.splitStringToSqlParams(toHiddenNodeCodes);
        String sql = " delete from ta_hide_node_config t " +
                     " where t.process_instance_id = ? "+
                     " and t.hidden_node_code = ?" +
                     " and t.to_hidden_node_code in ("+s+")";
        this.executeSql(sql,processInstanceId,hiddenNodeCode);
    }

    @Override
    public List<TaProcessNodeVo> findOpenNode(String processInstanceId,String processNodeCode) {
        String sql = " select " +
                     " t.hidden_node_code as processNodeCode,t.hidden_node_name as processNodeName " +
                     " from ta_hide_node_config t " +
                     " where t.process_instance_id = ?" +
                     " and t.to_hidden_node_code = ? ";
        List<TaProcessNodeVo> list = this.findBySql(TaProcessNodeVo.class, sql, processInstanceId, processNodeCode);
        return list;
    }

    @Override
    public void initCopy(TaHideNodeVo vo, ModelAndView view) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        String nodeCode = this.getNodeCode(taskId);
        String sql2 = "select distinct is_copy_cir as isCopyCir,is_communicate as isCommunicate from ta_hide_node_config where process_instance_id = ? and hidden_node_code = ? ";
        List<TaHideNodeVo> bySql = this.findBySql(TaHideNodeVo.class, sql2, processInstanceId, nodeCode);
        String s = null;
        String isc = null;
        if(CollectionUtil.listNotEmptyNotSizeZero(bySql)){
            s = bySql.get(0).getIsCopyCir();
            isc = bySql.get(0).getIsCommunicate();
        }else{
            s = "0";
            isc = "0";
        }
        view.addObject("isCopyCir",s);
        view.addObject("isCommunicate",isc);
    }

    @Override
    public void initAllNodeToHide(TaHideNodeVo vo) {
        List<TaHideNodeVo> hideNodeList = this.findHideNodeList(vo, null);
        String codes = "";
        String names = "";
        for (TaHideNodeVo taHideNodeVo : hideNodeList) {
            String processNodeCode = taHideNodeVo.getProcessNodeCode();
            String processNodeName = taHideNodeVo.getProcessNodeName();
            codes += processNodeCode + ",";
            names += processNodeName + ",";
        }
        if(StringUtils.isNotBlank(codes)){
            vo.setToHiddenNodeCodes(codes);
            vo.setToHiddenNodeNames(names);
            this.saveHideNode(vo);
        }
    }

    @Override
    public void delAllNodeToHide(TaHideNodeVo vo) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        this.validateNotNull(processInstanceId,taskId);
        String nodeCode = this.getNodeCode(taskId);
        String sql = "delete from ta_hide_node_config t where t.process_instance_id = ? and t.hidden_node_code = ?";
        this.executeSql(sql,processInstanceId,nodeCode);
    }

    /************************************************************************/

    private String getNodeName(String nodeCode,String processInstanceId){
        String sql = " select t1.process_node_name from ta_process_node t1 " +
                     " left join ta_process t2 on t1.process_id = t2.id" +
                     " left join ACT_RE_PROCDEF t3 on t2.process_key = t3.key_" +
                     " left join ACT_HI_PROCINST t4 on t3.id_ = t4.proc_def_id_" +
                     " where t4.proc_inst_id_ = ? and t1.process_node_code = ? ";
        List<TaProcessNodeVo> list = this.findBySql(TaProcessNodeVo.class, sql, processInstanceId, nodeCode);
        if(!CollectionUtil.listNotEmptyNotSizeZero(list)){
            throw new BusinessException("为找到该流程节点");
        }
        String processNodeName = list.get(0).getProcessNodeName();
        return processNodeName;
    }
    private String getNodeCode(String taskId){
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        return taskDefinitionKey;
    }
    private void validateNotNull(String... strs){
        for (String str : strs) {
            if(StringUtils.isBlank(str)){
                throw new BusinessException("必填参数为空,请检查");
            }
        }
    }

}
