package com.biz.eisp.activiti.listener.execution;

import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import com.biz.eisp.activiti.common.BusinessProcessEventBroadcaster;
import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.base.utils.ApplicationContextUtils;

/**
 * 本监听设置在整个流程上, 作为流程的结束监听 . 类名：ProcessEndListener 功能：流程实例结束监听器
 *
 */
public class ProcessEndListener implements ExecutionListener {

	private static final Logger logger = LoggerFactory.getLogger(ProcessEndListener.class);

	BusinessProcessEventBroadcaster broadCaster;

	/**
	 * @Fields serialVersionUID :
	 */
	private static final long serialVersionUID = 1L;

	@Override
	@Transactional
	public void notify(DelegateExecution execution) throws Exception {
		//如果是流程检测则直接返回，不用调用完成回调方法
		String formType = (String)execution.getVariable("FROM_TYPE");
		if(StringUtils.isNotBlank(formType) && "PROCESS_PASS_CHECK".equals(formType)) {
			return;
		}

		//获取流程结束的标识：是正常结束 还是 终止；
		Object isAbort = execution.getVariable("aborts");
		
		//Integer bmpStatus 默认正常结束
		Integer bmpStatus = Integer.valueOf(WorkFlowGlobals.BPM_BUS_STATUS_3);
		
		//isAbort 为 空表示是正常结束，反之终止
		if(isAbort != null && isAbort.equals(WorkFlowGlobals.BPM_KEY_ABORT)){
			bmpStatus = Integer.valueOf(WorkFlowGlobals.BPM_BUS_STATUS_4);
		}
		
		//追回
		if(isAbort != null && isAbort.equals(WorkFlowGlobals.BPM_BUS_STATUS_5)){
			bmpStatus = Integer.valueOf(WorkFlowGlobals.BPM_BUS_STATUS_5);
		}
		
		// 获取业务id  流程实例Id  
		String busKey = execution.getProcessBusinessKey();
		String processInstanceId = execution.getProcessInstanceId();
		String serviceName = (String) execution.getVariable(WorkFlowGlobals.BPM_SERVICE_NAME);

		//执行自己的业务逻辑
		broadCaster = (BusinessProcessEventBroadcaster) ApplicationContextUtils.getContext().getBean(serviceName);
		broadCaster.execute(processInstanceId, busKey, bmpStatus);
	}
}
