package com.biz.eisp.activiti.listener.task;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaCopyEntity;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang.StringUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/** 
 * 抄送监听
 * @author wan
 * @version v1.0
 */
public class CarbonCopyListener implements ExecutionListener{
	private static final long serialVersionUID = 1230733149844003676L;
	
	private TaCarbonCopyService taCarbonCopyService;
	private RepositoryService repositoryService;
	private HistoryService historyService;
	private TmActRoleService tmActRoleService;
	public CarbonCopyListener(){
		taCarbonCopyService = (TaCarbonCopyService) ApplicationContextUtils.getContext().getBean("taCarbonCopyService");
		repositoryService = (RepositoryService) ApplicationContextUtils.getContext().getBean("repositoryService");
		historyService = (HistoryService) ApplicationContextUtils.getContext().getBean("historyService");
		tmActRoleService = (TmActRoleService)ApplicationContextUtils.getContext().getBean("tmActRoleService");
	}
	
	@Override
	public void notify(DelegateExecution execution) throws Exception {
		//如果是流程检测则直接返回，不用调用完成回调方法
		String formType = (String)execution.getVariable("FROM_TYPE");
		if(StringUtils.isNotBlank(formType) && "PROCESS_PASS_CHECK".equals(formType)) {
			return;
		}
		//获取流程结束的标识：是正常结束 还是 终止；
		Object isAbort = execution.getVariable("aborts");
		if(isAbort == null){//当isAbort为空的时候,默认是通过
			carbonCopy(execution);
		}
	}
	
	
	/**
	 * 抄送监听：抄送-读取抄送配置表，抄送该流程
	 * @author wan
	 * @param execution
	 */
	private void carbonCopy(DelegateExecution execution){
		//流程实例id
		String piId = execution.getProcessInstanceId();
		//流程定义id
		String pdId = execution.getProcessDefinitionId();
		
		//查询流程定义信息
		ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionId(pdId).singleResult();
		//查询流程实例
		HistoricProcessInstance hpi = historyService.createHistoricProcessInstanceQuery().processInstanceId(piId).singleResult();
		
		//业务Id,查询该业务实体
		String businessKey = hpi.getBusinessKey();
		TaBaseBusinessObjQueryEntity businessObjEntity = taCarbonCopyService.get(TaBaseBusinessObjQueryEntity.class, businessKey);
		//得到创建人职位信息
		TmPositionEntity tmPositionEntity = businessObjEntity.getTmPositionEntity();//创建人
		
		//流程key
		String processKey = processDefinition.getKey();
		//流程名称
		String processName = processDefinition.getName();//流程名称
		
		//根据流程key，查询所有的该流程的配置信息
		List<TaCarbonCopyVo> ccs = taCarbonCopyService.getAllByProcessKey(processKey);
		
		//待插入到抄送表里的职位
		Set<String> innertPosition = new HashSet<>();
		
		//将配置信息表里的角色或者职位装载到集合中
		for(TaCarbonCopyVo vo : ccs){
			//当前组织 当前组织及以下
			String chooseCondition = vo.getChooseCondition();
			//角色 职位
			String state = vo.getState();
			//角色编码 或 职位编码
			String code = vo.getCode();
			
			if(state.equals("0")){//角色
				if(chooseCondition.equals("1")){//组织 + 角色
					List<TmPositionVo> positions = tmActRoleService.findCurrOrgPositionList(code,tmPositionEntity.getTmOrg().getId());//如果是1，那么根据发起人的组织查询
					for(TmPositionVo tm : positions)
						innertPosition.add(tm.getPositionCode());
				}else if(chooseCondition.equals("2")){//组织及以下+角色
					List<TmPositionVo> positions = tmActRoleService.findCurrAndBelowOrgPositionList(code,tmPositionEntity.getTmOrg().getId());
					for(TmPositionVo tm : positions)
						innertPosition.add(tm.getPositionCode());
				}else if(chooseCondition.equals("3")){//角色下所有职位
					List<TmPositionVo> positions = tmActRoleService.findPositionList(code);
					for(TmPositionVo tm : positions)
						innertPosition.add(tm.getPositionCode());
				}
			}else if(state.equals("1")){//职位
				innertPosition.add(code);
			}
		}
		
		//插入抄送表
		for(String str : innertPosition){
			TaCopyEntity copy = new TaCopyEntity();
			copy.setBusinessKey(businessKey);
			copy.setProcessInstanceId(piId);
			copy.setProcessName(processName);
			copy.setProcessKey(processKey);
			copy.setProcessTitle(businessObjEntity.getProcessTitle());
			copy.setCopyCode(str);
			copy.setCopyName("系统");//抄送默认是系统发起抄送
			copy.setViewStatus("0");
			copy.setCreateProcessPositionCode(tmPositionEntity.getPositionCode());
			copy.setCreateProcessPositionName(tmPositionEntity.getPositionName());
			
			taCarbonCopyService.save(copy);
		}
	}
}
