package com.biz.eisp.activiti.listener.task;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.springframework.transaction.annotation.Transactional;
import com.biz.eisp.base.common.util.StringUtil;

/**
 * 设置提交人的职位  
 * @author zkey
 *
 */
public class CreateTaskSetPositionOnFirstNodeListener implements TaskListener {

    /**
     * 
     */
    private static final long serialVersionUID = 7930090167155459394L;

    @Override
    @Transactional
    public void notify(DelegateTask delegateTask) {
    	//设置提交人的职位
    	String submitPositionId = (String) delegateTask.getVariable("submitPositionId");
		if(StringUtil.isEmpty(submitPositionId)){
			submitPositionId = ResourceConfigUtils.getCurrPosition().getId(); //当前人的职位
		}
		delegateTask.setVariable("submitPositionId", submitPositionId);
    }
}

