package com.biz.eisp.activiti.listener.task;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.task.IdentityLink;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/**
 * 当前组织审批监听器.
 * <p>
 * 
 * 结合任务中配置的角色， 设置当前任务配置的角色，并且该角色下的职位的所属组织等于当前操作者的组织的岗位来进行审批。<br>
 * 逻辑：
 * 1.工作流角色<br>
 * 2.拥有角色下的岗位<br>
 * 3.岗位的所属组织<br>
 * 4.该组织与操作者的组织相等<br>
 * 5.筛选出来的组织下的岗位信息进行审批
 * @author liukai
 * @version v1.0
 */
public class CurrentOrgListener implements TaskListener {

	//工作流角色管理Service
	public TmActRoleService tmActRoleService;
	
	public CurrentOrgListener() {
		tmActRoleService= (TmActRoleService) ApplicationContextUtils.getContext()
				.getBean("tmActRoleService");
	}
	
	@Override
	public void notify(DelegateTask delegateTask) {
		Set<IdentityLink> identityLinkList = delegateTask.getCandidates(); //获取任务中配置的角色列表

		for (Iterator<IdentityLink> iter = identityLinkList.iterator(); iter.hasNext();) {
			IdentityLink id = iter.next();
			String actRoleCode = id.getGroupId(); //角色编号

			//第一次提交将提交人的组织id放入到流程变量中
			String orgId = (String) delegateTask.getVariable("submitOrgId");
			if(StringUtil.isEmpty(orgId)){
				orgId = ResourceConfigUtils.getCurrPosition().getOrgId(); //当前组织ID
			}

			List<TmPositionVo> voList = tmActRoleService.findCurrOrgPositionList(actRoleCode, orgId);

			if (voList != null) {
				if (voList.size() == 1) {
					delegateTask.setAssignee(voList.get(0).getPositionCode());
				} else {
					for (TmPositionVo vo : voList) {
						delegateTask.addCandidateUser(vo.getPositionCode());
					}
				}
			} else {
				throw new BusinessException("未找到审批职位，请联系系统管理员");
			}
		}
	}
}
