package com.biz.eisp.activiti.listener.task;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.biz.eisp.base.common.exception.BusinessException;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.task.IdentityLink;

import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/**
 * 监听:查询-根据配置工作流角色编码，查询与角色所有有关的职位可以审批当前节点
 * @author wan
 * @version v1.0
 */
public class FindPostionByRoleCodeListener implements TaskListener{
	private static final long serialVersionUID = -5791264398316486473L;
	
	
	private TmPositionService positionService;
	
	public FindPostionByRoleCodeListener() {
		positionService = (TmPositionService) ApplicationContextUtils.getContext().getBean("tmPositionService");
	}
	@Override
	public void notify(DelegateTask delegateTask) {
		this.findPostionByRole(delegateTask);
	}
	private void findPostionByRole(DelegateTask delegateTask){
		Set<IdentityLink> identityLinkList = delegateTask.getCandidates(); // 获取任务中配置的角色列表
		for (Iterator<IdentityLink> iter = identityLinkList.iterator(); iter.hasNext();) {
			IdentityLink id = iter.next();
			String actRoleCode = id.getGroupId(); // 角色编号

			String sql = " select t2.id as id,t2.position_code as positionCode,t2.position_name as positionName from tm_r_position_act_role t1 "+
			             " inner join tm_position t2 on t1.position_id = t2.id left join tm_act_role t3 on t1.role_id = t3.id where t3.role_code = ?";
			
			List<TmPositionVo> list = positionService.findBySql(TmPositionVo.class, sql, actRoleCode);
			if (list != null) {
				if (list.size() == 1) {
					delegateTask.setAssignee(list.get(0).getPositionCode());
				} else {
					for (TmPositionVo vo : list) {
						delegateTask.addCandidateUser(vo.getPositionCode());
					}
				}
			} else {
				throw new BusinessException("未找到审批职位，请联系系统管理员");
			}
		}
	}
}
