package com.biz.eisp.activiti.listener.task;

import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * 任务自动通过 通过组织来确定
 * @author zkey
 *
 */
@SuppressWarnings("deprecation")
public class JumpTaskByOrgListener implements TaskListener {

    private static final Logger logger = LoggerFactory.getLogger(JumpTaskByOrgListener.class);
    /**
     * 
     */
    private static final long serialVersionUID = 7930090167155459394L;

    @Override
    @Transactional
    public void notify(DelegateTask delegateTask) {
    	TaskService taskService = ApplicationContextUtils.getContext().getBean(TaskService.class);
    	BaseService baseService = (BaseService) ApplicationContextUtils.getContext().getBean("baseService");
    	
    	String jump = (String) delegateTask.getVariable("jump");
    	logger.info("获取到跳转标识：jump="+jump);
    	
    	if(jump != null && "yes".equals(jump)){
    		//获取到执行流 id
    		String executionId = delegateTask.getExecutionId();
    		//通过执行流id 获取任务id
    	
    		//自动通过任务
    		taskService.complete(delegateTask.getId());
    			
    		//记录日志
    		TmUserEntity user = ResourceConfigUtils.getClient().getUser();
    		TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
    		log.setCreateDate(new Date());
    		log.setAccount(user.getUserName());
    		log.setContent("自动跳过");
    		log.setName(user.getFullName());
    		log.setProcessInstId(delegateTask.getProcessInstanceId());
    		log.setTaskDefKey(delegateTask.getTaskDefinitionKey());
    		log.setType(1);
    		baseService.save(log);
			baseService.getSession().flush();
    	}
    }
}

