package com.biz.eisp.activiti.listener.task;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.task.IdentityLink;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/**
 * 找到父级职位
 * @author zkey
 */
public class ParentPositionListener implements TaskListener {

	private static final long serialVersionUID = 1L;
	//工作流角色管理Service
	private TmActRoleService tmActRoleService;

	public ParentPositionListener() {
		tmActRoleService = (TmActRoleService) ApplicationContextUtils.getContext().getBean("tmActRoleService");
	}

	@Override
	public void notify(DelegateTask delegateTask) {
		Set<IdentityLink> identityLinkList = delegateTask.getCandidates(); // 获取任务中配置的角色列表

		for (Iterator<IdentityLink> iter = identityLinkList.iterator(); iter.hasNext();) {
			IdentityLink id = iter.next();
			String actRoleCode = id.getGroupId(); // 角色编号

			String submitPositionId = (String) delegateTask.getVariable("submitPositionId");
			if(StringUtil.isEmpty(submitPositionId)){
				submitPositionId = ResourceConfigUtils.getCurrPosition().getId(); //当前职位ID
			}

			//需要找到直接上级 职位
			TmPositionEntity tp = tmActRoleService.get(TmPositionEntity.class, submitPositionId);
			TmPositionEntity parentPostion = tp.getTmPosition();
			if(parentPostion == null){
				throw new BusinessException("请配置你的上级职位");
			}
			String parent  = parentPostion.getId();
			
			List<TmPositionVo> voList = tmActRoleService.findParentPositionList(actRoleCode,parent);

			if (voList != null) {
				if (voList.size() == 1) {
					delegateTask.setAssignee(voList.get(0).getPositionCode());
				} else {
					for (TmPositionVo vo : voList) {
						delegateTask.addCandidateUser(vo.getPositionCode());
					}
				}
			} else {
				throw new BusinessException("未找到审批职位，请联系系统管理员");
			}
		}
	}

}
