package com.biz.eisp.activiti.listener.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;

/** 
 * 抄送监听
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author wan
 * @version v1.0
 */
public class RejectListener implements TaskListener{
	private static final long serialVersionUID = 1230733149844003676L;

	@SuppressWarnings("unchecked")
	@Override
	public void notify(DelegateTask dt) {
		// 从流程变量获取可以驳回的任务节点id集合
        List<Map<String, String>> ids = (List<Map<String, String>>) dt.getVariable("carbonCopyList");
        if (ids == null) {
            ids = new ArrayList<Map<String, String>>();
        }
        // 将当前任务id,name 放于可驳回的集合
        boolean notHas = true;
        for (Map<String, String> m : ids) {
            if (dt.getTaskDefinitionKey().equals((String) m.get("id"))) {
                notHas = false;
                break;
            }
        } 
        if (notHas) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("id", dt.getTaskDefinitionKey());//节点的id
            map.put("name", dt.getName());//节点的名称
            ids.add(map);
        }
        dt.setVariable("carbonCopyList", ids);
	}

	
	
	
	
	
	
	
	
	
	
	
	
}
