package com.biz.eisp.activiti.listener.task;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.task.IdentityLink;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/**
 * 按照负责的大区过滤 
 * @author zkey
 *
 */
public class ResponsibleAreaListener implements TaskListener {

	private static final long serialVersionUID = 1L;
	//工作流角色管理Service
	private TmActRoleService tmActRoleService;

	public ResponsibleAreaListener() {
		tmActRoleService = (TmActRoleService) ApplicationContextUtils.getContext().getBean("tmActRoleService");
	}

	@Override
	public void notify(DelegateTask delegateTask) {
		Set<IdentityLink> identityLinkList = delegateTask.getCandidates(); // 获取任务中配置的角色列表

		for (Iterator<IdentityLink> iter = identityLinkList.iterator(); iter.hasNext();) {
			IdentityLink id = iter.next();
			String actRoleCode = id.getGroupId(); // 角色编号
	
			//第一次提交将提交人的组织id放入到流程变量中
			String orgId = (String) delegateTask.getVariable("submitOrgId");
			if(StringUtil.isEmpty(orgId)){
				orgId = ResourceConfigUtils.getCurrPosition().getOrgId(); //当前组织ID
			}
			TmOrgEntity org = tmActRoleService.get(TmOrgEntity.class, orgId);
			List<TmPositionVo> voList = tmActRoleService.findResponsibleArea(actRoleCode, org.getOrgCode());

			if (voList != null) {
				if (voList.size() == 1) {
					delegateTask.setAssignee(voList.get(0).getPositionCode());
				} else {
					for (TmPositionVo vo : voList) {
						delegateTask.addCandidateUser(vo.getPositionCode());
					}
				}
			}
		}
	}

}
