/**  
 * @Title: TurnBackTaskListener.java
 * @date 2013-8-19 下午4:26:40
 * @Copyright: 2013 
 */
package com.biz.eisp.activiti.listener.task;

import com.biz.eisp.base.utils.ApplicationContextUtils;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.task.Task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 驳回监听器 将此监听器放在可以驳回的用户任务，事件：complete(任务完成) 允许驳回到此任务节点，将此任务放入可驳回列表.
 * <p>
 * @author liukai
 * @version v1.0
 */
public class TurnBackTaskListener implements TaskListener {

    /**
     * @Fields serialVersionUID :
     */

    private static final long serialVersionUID = 1L;

    @Override
    public void notify(DelegateTask dt) {
    	//流程 通过 / 驳回上一人 标识
    	String approveOpt= (String)dt.getVariable("approveOpt");

    	//获取任务列表，必须会签所有节点都通过 当列表任务节点为1时，说明已经审批完成，可以进入下一个节点
		TaskService taskService = ApplicationContextUtils.getContext().getBean(TaskService.class);
		List <Task> list = taskService.createTaskQuery().processInstanceId(dt.getProcessInstanceId()).list();

    	if("PASS".equals(approveOpt) && list.size() == 1) {//当改节点是pass
			// 从流程变量获取可以驳回的任务节点id集合
			List<Map<String, String>> ids = (List<Map<String, String>>) dt.getVariable("backTaskIds");
			if (ids == null) {
				ids = new ArrayList<Map<String, String>>();
			}
			// 将当前任务id,name 放于可驳回的集合
			boolean notHas = true;
			for (Map<String, String> m : ids) {
				if (dt.getTaskDefinitionKey().equals((String) m.get("id"))) {
					notHas = false;
					break;
				}
			}
			if (notHas) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("id", dt.getTaskDefinitionKey());
				map.put("name", dt.getName());
				ids.add(map);
			}
			dt.setVariable("backTaskIds", ids);
		}
    }
}
