package com.biz.eisp.activiti.runtime.cmd;


import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;

import java.util.Map;
/** 
 * @Description:
 * @Author: xuduan 
 * @Date: 2018/4/17 上午10:48
 */
public class JumpTaskCmd implements Command<Void> {

    private TaskEntity taskEntity;
    private ActivityImpl targetActivity;
    protected Map<String, Object> variables;

    public  JumpTaskCmd(TaskEntity taskEntity, ActivityImpl targetActivity, Map<String, Object> variables){
        this.taskEntity = taskEntity;
        this.targetActivity = targetActivity;
        this.variables = variables;
    }

    @Override
    public Void execute(CommandContext commandContext){
        if(taskEntity != null){

            // 如果以后有那种在这个要删除的task中有变量需要存储，然后不需要存在全局中时需要做扩展修改，目前一直只用全局变量，所以不用处理
//            if(variables != null){
//
//            }else{
//
//            }

            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, TaskEntity.DELETE_REASON_COMPLETED, false);
            ExecutionEntity execution = taskEntity.getExecution();
            execution.setVariables(variables);
            execution.setActivity(targetActivity);
            execution.performOperation(AtomicOperation.ACTIVITY_START);
        }

        return null;
    }
}
