package com.biz.eisp.activiti.runtime.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaAttachmentVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.core.entity.TbAttachmentEntity;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.MyClassLoader;
import com.biz.eisp.base.utils.UploadFile;

/** 工作流附件管理.
 * <p>
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taAttachmentController")
public class TaAttachmentController extends BaseController{

	@Autowired
	private TaAttachmentService taAttachmentService;
	
	@RequestMapping(value = "saveFiles", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response) {
		AjaxJson j = new AjaxJson();
		
		try {
			String taskId = request.getParameter("taskId");
			TaAttachmentEntity ta = new TaAttachmentEntity();
			ta.setTaskId(taskId);
			UploadFile uploadFile = new UploadFile(request, ta);
			ta.setSubclassName(TaAttachmentEntity.class.getName());
			uploadFile.setCusPath("resources/upload");
			uploadFile.setExtend("extend");
			uploadFile.setTitleField("attachmentTitle");
			uploadFile.setRealPath("realPath");
			uploadFile.setObject(ta);
			uploadFile.setRename(true);

			taAttachmentService.uploadFile(uploadFile, null, null);

			List<TaAttachmentVo> myAttachmentList = taAttachmentService.findAttachmentList(taskId);
			Map<String, Object> attributes = new HashMap<String, Object>();
			attributes.put("url", ta.getRealPath());
			attributes.put("fileKey", ta.getId());
			attributes.put("name", ta.getAttachmentTitle());
			attributes.put("delurl", "taTaskController.do?delObjFile&fileKey=" + ta.getId());
			attributes.put("myAttachmentList", myAttachmentList);
			j.setAttributes(attributes);
			j.setMsg("文件添加成功");
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		return j;
	}

	@RequestMapping(value = "delObjFile", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delObjFile(HttpServletRequest request) {
		String message = null;
		AjaxJson j = new AjaxJson();
		try {
			String fileKey = OConvertUtils.getString(request.getParameter("fileKey"));// 文件ID
			TbAttachmentEntity attachment = taAttachmentService.get(TbAttachmentEntity.class, fileKey);
			String subclassname = attachment.getSubclassName(); // 子类类名
			Object objfile = taAttachmentService.get(MyClassLoader.getClassByScn(subclassname), attachment.getId());// 子类对象
			message = "" + attachment.getAttachmentTitle() + "删除成功";
			taAttachmentService.delete(objfile);
		} catch(Exception e) {
			e.printStackTrace();
		}
		j.setMsg(message);
		return j;
	}

	@RequestMapping(value = "viewFile", method = {RequestMethod.GET, RequestMethod.POST})
	public void viewFile(HttpServletRequest request, HttpServletResponse response) {
		String fileid = OConvertUtils.getString(request.getParameter("fileid"));
		String subclassname = OConvertUtils.getString(request.getParameter("subclassName"),
				"com.biz.eisp.base.core.entity.TbAttachmentQueryEntity");
		Class fileClass = MyClassLoader.getClassByScn(subclassname);// 附件的实际类
		Object fileobj = taAttachmentService.get(fileClass, fileid);
		ReflectHelper reflectHelper = new ReflectHelper(fileobj);
		UploadFile uploadFile = new UploadFile(request, response);
		String contentfield = OConvertUtils.getString(request.getParameter("contentfield"), uploadFile.getByteField());
		byte[] content = (byte[]) reflectHelper.getMethodValue(contentfield);
		String path = OConvertUtils.getString(reflectHelper.getMethodValue("realPath"));
		String extend = OConvertUtils.getString(reflectHelper.getMethodValue("extend"));
		String attachmenttitle = OConvertUtils.getString(reflectHelper.getMethodValue("attachmentTitle"));
		uploadFile.setExtend(extend);
		uploadFile.setTitleField(attachmenttitle);
		uploadFile.setRealPath(path);
		uploadFile.setContent(content);
		// uploadFile.setView(true);
		taAttachmentService.viewOrDownloadFile(uploadFile);
	}

	@RequestMapping(value = "findAttachmentList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findAttachmentList(MyTaskVo myTaskVo, HttpServletRequest request, HttpServletResponse response) {
		List<TaAttachmentVo> taskList = taAttachmentService.findAttachmentList(myTaskVo.getTaskId());
		return new DataGrid(taskList, null);
	}
}
