package com.biz.eisp.activiti.runtime.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.runtime.vo.*;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.service.TaHandCopyAndCirculationService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/** 
 * 抄送
 * @author wan
 * @version v1.0
 */
@Controller
@RequestMapping("/taCarbonCopyController")
public class TaCarbonCopyController {
	
	@Autowired
	private TaCarbonCopyService taCarbonCopyService;
	@Autowired(required = false)
	private RepositoryService repositoryService;
	@Autowired
	private TaskService taskService;
	@Autowired
	private TaProcessService taProcessService;
	@Autowired
	private TmPositionService tmPositionService;
	@Autowired
	private TmActRoleService tmActRoleService;
	@Autowired
	private TaTaskService taTaskService;
	@Autowired
	private TaHandCopyAndCirculationService taHandCopyAndCirculationService;
	@Autowired
	private RuntimeService runtimeService;
	
	
	/**
	 * 抄送：跳转-至抄送配置页面
	 * @author wan
	 * taProcessId 流程id
	 * @return 视图->carbonCopyMain
	 */
	@RequestMapping(value = "goAddCarbonCopyMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goAddCarbonCopyMain(String id){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/carbonCopyMain");//抄送配置页面
		view.addObject("taProcessId", id);
		return view;
	}
	
	
	/**
	 * 抄送：查询-抄送配置界面，工作流角色/职位的查询
	 * @author wan
	 * @param sendType 0:角色 1职位
	 * positionName 职位名称
	 * @param roleName 角色名称
	 * orgId 组织id
	 * @param request request
	 * @return dataGrid
	 */
	@RequestMapping(value = "getRolesOrPositions", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid getRolesOrPositions(String sendType,TmPositionVo vo,String roleName,String roleCode,HttpServletRequest request){
		Page page = new EuPage(request);
		DataGrid dataGrid = null;
		if(sendType != null && "0".equals(sendType) || "".equals(sendType)){//查询角色
			
			//设置查询条件
			TmActRoleVo query = new TmActRoleVo();
			query.setRoleName(roleName);
			query.setRoleCode(roleCode);
			
			//查询角色
			List<TmActRoleVo> roles = tmActRoleService.findActRoleMain(query,page);
			
			dataGrid = new DataGrid(roles,page);
		}else if(sendType != null && sendType.equals("1")){//查询职位
			TmPositionVo query = new TmPositionVo();
			if(!"-1".equals(vo.getOrgId()) && vo.getOrgId() != null){
				query.setOrgId(vo.getOrgId());
			}
			query.setPositionName(vo.getPositionName());
			query.setPositionCode(vo.getPositionCode());
			query.setFullName(vo.getFullName());
			List<TmPositionVo> positions = tmPositionService.findPositionByConditions(query,page);
			dataGrid = new DataGrid(positions,page);
		}
		return dataGrid;
	}
	
	
	/**
	 * 抄送：保存-抄送配置
	 * @author wan
	 * @param vo 添加的内容
	 * @return
	 */
	@RequestMapping(value = "saveCarbonCopy", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveCarbonCopy(TaCarbonCopyVo vo){
		AjaxJson aj = new AjaxJson();
		try {
			aj = taCarbonCopyService.saveCarbonCopy(vo);
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg("保存失败");
			e.printStackTrace();
		}
		return aj;
	}
	
	
	
	/**
	 * 抄送：查询-根据流程id，查询已配置的抄送角色/职位
	 * @author wan
	 * taProcessId 流程id
	 * createPosition 创建抄送人的职位code
	 * @param request request
	 * @return
	 */
	@RequestMapping(value = "findCarbonCopyByTaProcessId", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findCarbonCopyByTaProcessId(TaCarbonCopyVo taCarbonCopyVo,HttpServletRequest request){
		Page page = new EuPage(request);
		List<TaCarbonCopyVo> result = taCarbonCopyService.findTaCarbonCopy(taCarbonCopyVo,page);
		return new DataGrid(result, page);
	}
	
	/**
	 * 抄送：删除-删除已经配置的抄送角色/职位
	 * @author wan
	 * @param delIds 多个id
	 * @return
	 */
	@RequestMapping(value = "delCarbonCopyById", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delCarbonCopyById(String delIds){
		AjaxJson aj = new AjaxJson();
		try {
			taCarbonCopyService.delCarbonCopyById(delIds);
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg("数据库发生异常");
			e.printStackTrace();
		}
		return aj;
	}
	
	
	/**
	 * 抄送传阅：查询-首页数据 抄送/传阅
	 * @author wan
	 * @param vo 查询条件
	 * @param time 时间条件
	 * @param request request
	 * @return dataGrid
	 */
	@RequestMapping(value = "findHomeCarbonCopyList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findHomeCarbonCopyList(TaCopyCirculationVo vo,String time,HttpServletRequest request){
		//首页查询抄送和传阅，查询抄送给我的 和传阅给我的，只有这两个 
		Page page = new EuPage(request);
		vo.setCreateDate(time);
		List<TaCopyCirculationVo> result = taCarbonCopyService.findCopyAndCirculation(vo, page);
		return new DataGrid(result, page);
	}
	
	
	
	
	/**
	 * 抄送传阅：跳转-我的抄送(包括传阅数据)
	 * @author wan
	 * @return
	 */
	@RequestMapping(params = "goCarbonCopyMain")
	public ModelAndView goCarbonCopyMain(){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/taMyCarbonCopy");
		return view;
	}
	/**
	 * 抄送传阅：查询-我的抄送页面显示列表
	 * @author wan
	 * @param vo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "findCarbonCopyList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findCarbonCopyList(TaCopyCirculationVo vo,HttpServletRequest request){
		Page page = new EuPage(request);
		List<TaCopyCirculationVo> result = taCarbonCopyService.getCarbonCopyByConditions(vo,page);
		return new DataGrid(result, page);
	}
	
	
	/**
	 * 传阅：跳转-传阅配置页面
	 * @author wan
	 * @param processInstanceId 流程实例id
	 * @return
	 */
	@RequestMapping(value = "goAddCirculationMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goAddCirculationMain(String processInstanceId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/circulationMain");

		view.addObject("processInstanceId", processInstanceId);
		
		return view;
	}
	
	
	/**
	 * 传阅：保存-传阅主页，保存传阅数据
	 * @author wan
	 * @return
	 */
	@RequestMapping(value = "saveCirculation", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveCirculation(String processInstanceId,String codes,String names,String fullNames, String content){
		AjaxJson aj = new AjaxJson();
		try {
			taCarbonCopyService.saveCirculation(processInstanceId, codes, names,fullNames,content);
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg(e.getMessage());
			e.printStackTrace();
		}
		return aj;
	}
	
	/**
	 * 传阅：保存-传阅人传回的内容
	 * @author wan
	 * @param id  传阅内容表id
	 * @param content 传回的内容
	 * @return
	 */
	@RequestMapping(value = "saveCirculationContent", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveCirculationContent(String id,String content){
		AjaxJson aj = new AjaxJson();
		try {
			taHandCopyAndCirculationService.saveCirculationContent(id, content);
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg("数据库操作发生异常");
			e.printStackTrace();
		}
		return aj;
	}
	
	/**
	 * 抄送传阅查看：跳转-抄送/传阅 tab标签页面
	 * @author wan
	 * @param vo 查阅的类型：0标识查看别人传阅给我的内容 1标识查看我传阅给别人的内容，包括传回的内容
	 * @return
	 */
	@RequestMapping(value = "goCopyAndCirculationTabs", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCopyAndCirculationTabs(TaCopyCirculationVo vo){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyAndCirculationTab");
		try {
			//首页跳转，那么更新查阅状态
//			taHandCopyAndCirculationService.updateCarbonOrCirculationState(vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		view.addObject("query", vo);//抄送和传阅相关的信息
		return view;
	}
	@RequestMapping(value = "updateCarbonOrCirculationState", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson updateCarbonOrCirculationState(TaCopyCirculationVo vo){
		AjaxJson aj = new AjaxJson();
		try {
			taHandCopyAndCirculationService.updateCarbonOrCirculationState(vo);
		}catch(Exception e){
			aj.setSuccess(false);
			aj.setMsg(e.getMessage());
		}
		return aj;
	}

	/**
	 * 抄送传阅查看：跳转-抄送/传阅tab 业务数据页面 1
	 * @author wan
	 * @param businessKey 业务id
	 * @param processInstanceId 流程实例id
	 * @return
	 */
	@RequestMapping(value = "goCopyAndCirculationBusiness", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCopyAndCirculationBusiness(String businessKey,String processInstanceId,HttpServletRequest request){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyAndCirculationBusinessForm");
		//将获取的内容放在request中的
		MyTaskVo queryVo = new MyTaskVo();
		queryVo.setProcessInstanceId(processInstanceId);
		taTaskService.findProcessBasicInfoByProcinstId(queryVo,request);
		//获取附件
		taTaskService.findAttachmentListByProcinstId(processInstanceId,request);
		return view;
	}

	/**
	 * 抄送传阅查看：跳转-抄送/传阅tab 流程图界面 3
	 * @author wan
	 * @param vo 条件
	 * @param request request
	 * @return 视图modelAndView
	 */
	@RequestMapping(value = "goCopyAndCirculationTaskForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCopyAndCirculationTaskForm(TaCopyCirculationVo vo,HttpServletRequest request){
		ModelAndView view = null;
		TaCopyCirculationVo queryVo = new TaCopyCirculationVo();
		List<TaCopyCirculationVo> result = null;

		if("0".equals(vo.getInOutType())){//传阅给我
			view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateInForm");
			//设置查询条件
			queryVo.setId(vo.getId());
			queryVo.setQueryCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
			//查询传阅详细数据
			result = taHandCopyAndCirculationService.findCirculationMessage(queryVo);
			//是否可以回复
			String isReply = "0";
			//循环：如果当回复标志只要有一个为1，那么就不可以进行回复，因为有可能同一个流程传递多次给同一个人
			for(TaCopyCirculationVo v : result){
				if("1".equals(v.getIsReply())){
					isReply = "1";
					break;
				}
			}
			view.addObject("isReply",isReply);
		}else if("1".equals(vo.getInOutType())){//我传阅出去
			view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateOutForm");
			//设置查询条件
			queryVo.setId(vo.getId());
			queryVo.setContentId(vo.getContentId());
			//查询传阅详细数据
			result = taHandCopyAndCirculationService.findCirculationMessage(queryVo);
		}

		//流程实例id
		String piId = vo.getProcessInstanceId();
		ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
		//判断流程是否已经结束
		if(processInstance == null){
			view.addObject("taskState", 0);
		}else{
			view.addObject("taskState", 1);
		}

		view.addObject("content", result);
		view.addObject("inOutType", vo.getInOutType());

		return view;
	}
	/**
	 * 抄送传阅查看：跳转-抄送/传阅tab 审批详情页面 2
	 * @author wan
	 * @param vo 查询条件
	 * @return
	 */
	@RequestMapping(value = "goCopyOrCirculationOperateForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCopyOrCirculationOperateForm(TaCopyCirculationVo vo,HttpServletRequest request){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyOperateForm");
		request.setAttribute("processInstanceId",vo.getProcessInstanceId());
		this.setKeyIndicators(vo.getProcessInstanceId(), request);
		MyTaskVo taskVo = new MyTaskVo();
		taskVo.setIsCommunicate("C");//占用下包含其他意思的字段,用于辩于抄送传阅
		taskVo.setProcessInstanceId(vo.getProcessInstanceId());
		this.taTaskService.findApprovalLogs(taskVo,request);
		return view;
	}
	//设置关键业务指标
	private void setKeyIndicators(String processInstanceId, HttpServletRequest request) {
		String modelAndView = taTaskService.getProcessInstanceBusinessForm(processInstanceId);
		if(modelAndView != null) {
			modelAndView += "&isKeyIndicators=true";
		}
		request.setAttribute(WorkFlowGlobals.PROCNODE_START, modelAndView);
	}

//	/**
//	 * 抄送传阅查看：跳转-抄送/传阅tab 审批详情页面 2
//	 * @author wan
//	 * @param vo 查询条件
//	 * @return
//	 */
//	@RequestMapping(params = "goCopyOrCirculationOperateForm")
//	public ModelAndView goCopyOrCirculationOperateForm(TaCopyCirculationVo vo){
//		ModelAndView view = null;
//		//查询流程实例审批记录列表
//		List<CommentVo> list = taTaskService.findActHiCommentEntity(vo.getProcessInstanceId());
//		if("0".equals(vo.getType())){//抄送
//			view = new ModelAndView("com/biz/eisp/activiti/runtime/copyOperateForm");
//		}else if("1".equals(vo.getType())){//传阅
//			//查询条件
//			TaCopyCirculationVo queryVo = new TaCopyCirculationVo();
//			//查询结果
//			List<TaCopyCirculationVo> result = null;
//			if("0".equals(vo.getInOut())){//传阅给我
//				view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateInForm");
//				//设置查询条件
//				queryVo.setId(vo.getId());
//				queryVo.setQueryCode(ResourceUtil.getCurrPosition().getPositionCode());
//				//查询传阅详细数据
//				result = taHandCopyAndCirculationService.findCirculationMessage(queryVo);
//				//是否可以回复
//				String isReply = "0";
//				//循环：如果当回复标志只要有一个为1，那么就不可以进行回复，因为有可能同一个流程传递多次给同一个人
//				for(TaCopyCirculationVo v : result){
//					if("1".equals(v.getIsReply())){
//						isReply = "1";
//						break;
//					}else{
//						isReply = "0";
//					}
//				}
//				view.addObject("isReply",isReply);
//			}else if("1".equals(vo.getInOut())){//我传阅出去
//				view = new ModelAndView("com/biz/eisp/activiti/runtime/taCirculationOperateOutForm");
//				//设置查询条件
//				queryVo.setId(vo.getId());
//				//查询传阅详细数据
//				result = taHandCopyAndCirculationService.findCirculationMessage(queryVo);
//			}
//			//流程实例id
//			String piId = vo.getProcessInstanceId();
//			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
//			//判断流程是否已经结束
//			if(processInstance == null){
//				view.addObject("taskState", 0);
//			}else{
//				view.addObject("taskState", 1);
//			}
//			view.addObject("content", result);
//			view.addObject("inOut", vo.getInOut());
//		}
//		view.addObject("voList",list);
//		return view;
//	}

	/**
	 * 跳转-抄送人员信息列表页面
	 * @author liukia
	 * @return
	 */
	@RequestMapping(value = "goCopyPersonInfoMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goCopyPersonInfoMain(String processInstanceId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/copyPersonInfoMain");
		return view;
	}

	/**
	 * 查询抄送人员信息列表页面
	 * @author wan
	 * @param vo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "findCopyPersonInfoList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findCopyPersonInfoList(TaCopyPersonInfoVo vo, HttpServletRequest request){
		Page page = new EuPage(request);
		List<TaCopyPersonInfoVo> result = taCarbonCopyService.findCopyPersonInfoList(vo,page);
		return new DataGrid(result, page);
	}
}
