package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.activiti.runtime.service.TaCommunicateService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.core.web.BaseController;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 沟通Controller
 * Created by liukai on 2017/8/9.
 */
@Controller
@RequestMapping("/taCommunicateController")
public class TaCommunicateController extends BaseController{

    /**
     * 注入沟通Service
     */
    @Autowired
    private TaCommunicateService taCommunicateService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaProcessService taProcessService;

    /**
     * 抄送：跳转-至沟通配置页面
     * @param taskId
     * @return
     */
    @RequestMapping(value = "goAddCommunicateMain", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goAddCommunicateMain(String taskId){
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/communicateMain");//抄送配置页面
        //根据任务id查询任务信息
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();

        //查询流程定义信息
        ProcessDefinition pd = repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();

        //根据流程key查询流程主体
        TaProcessVo processVo = taProcessService.findProcessByKey(pd.getKey());

        view.addObject("taProcessId", processVo.getId());
        view.addObject("taskId", taskId);

        return view;
    }

    /**
     * 保存沟通信息
     * @return
     */
    @RequestMapping(value = "saveCommunicate",method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveCommunicate(String taskId,String codes,String names,String fullNames, String content, String forceReplyFlag){
        AjaxJson aj = new AjaxJson();
        aj.setSuccess(true);
        try {
            ValidForm validForm = taCommunicateService.saveCommunicate(taskId, codes, names, fullNames, content, forceReplyFlag);
            if(validForm.getStatus().equals("N")) {
                aj.setSuccess(false);
                aj.setMsg(validForm.getInfo());
            }
        } catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("保存失败");
            e.printStackTrace();
        }
        return aj;
    }

    @RequestMapping(value = "saveSureCommunicate",method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveSureCommunicate(String communicateId,String content){
        AjaxJson aj = new AjaxJson();
        aj.setSuccess(true);
        try {
            ValidForm validForm = taCommunicateService.saveSureCommunicate(communicateId, content);
            if(validForm.getStatus().equals("N")) {
                aj.setSuccess(false);
                aj.setMsg(validForm.getInfo());
            }
        } catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("保存失败");
            e.printStackTrace();
        }
        return aj;
    }

}
