package com.biz.eisp.activiti.runtime.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.biz.eisp.activiti.runtime.service.TaDeploymentService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.web.BaseController;

/**
 * 流程发布管理.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taDeploymentController")
public class TaDeploymentController extends BaseController {

	@Autowired
	private TaDeploymentService taDeploymentService;

	@RequestMapping(value = "deployProcess", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deployProcess(HttpServletRequest request) {
		String processId = request.getParameter("id");
		try {
			taDeploymentService.deployProcess(processId);
			return new AjaxJson("发布成功");
		} catch (Exception e) {
			return new AjaxJson("发布失败"+ e.getMessage());
		}
	}
}
