package com.biz.eisp.activiti.runtime.controller;

import java.io.InputStream;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.biz.eisp.activiti.runtime.vo.ProcessInstanceVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/**
 * 流程实例管理.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taProcessInstanceController")
public class TaProcessInstanceController extends BaseController {

	@Autowired
	private TaProcessInstanceService taProcessInstanceService;

	/**
	 * 启动业务流程.
	 * <p>
	 * 
	 * @param taProcessBusinessObjConfigVo
	 *            工作流设计与业务关系Vo对象
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "startBusinessProcess", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson startBusinessProcess(TaProcessBusinessObjConfigVo taProcessBusinessObjConfigVo,
			HttpServletRequest request, HttpServletResponse response) {
		AjaxJson aj = new AjaxJson();
		try {
			taProcessInstanceService.saveStartWorkflow(taProcessBusinessObjConfigVo);
			aj.setSuccess(true);
			aj.setMsg("启动成功");
		} catch (Exception e) {
			e.printStackTrace();
			aj.setMsg("启动业务流程失败：" + e.getMessage());
		}
		return aj;
	}

	/**
	 * 跳转到我发起的流程页面
	 * <p>
	 * 
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "goMyStartedProcessMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goMyStartedProcessList(HttpServletRequest request, HttpServletResponse response) {
		return new ModelAndView("com/biz/eisp/activiti/instance/myStartedProcessMain");
	}

	@RequestMapping(value = "goProcessInstanceMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goProcessInstanceMain(HttpServletRequest request, HttpServletResponse response) {
		return new ModelAndView("com/biz/eisp/activiti/instance/processInstanceMain");
	}
	
	/**
	 * 查询我发起的流程信息列表
	 * <p>
	 * 
	 * @param myInstanceVo
	 * @param request
	 * @param response
	 * @return 我发起的流程Vo对象列表
	 */
	@RequestMapping(value = "findMyStartedProcessList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findMyStartedProcessList(MyInstanceVo myInstanceVo,String time, HttpServletRequest request,
			HttpServletResponse response) {
		Page page = new EuPage(request);
		//设置获取当前登录者职位编码信息
		TmPositionVo tmPositionVo = ResourceConfigUtils.getCurrPosition();
		myInstanceVo.setStartPositionCode(tmPositionVo.getPositionCode());
		myInstanceVo.setStartTime(time);
		
		List<MyInstanceVo> voList = taProcessInstanceService.findMyStartedProcessList(myInstanceVo, page);
		return new DataGrid(voList, page);
	}

	/**
	 * 查询流程实例信息列表
	 * <p>
	 * @param request
	 * @param response
	 * @return 我发起的流程Vo对象列表
	 */
	@RequestMapping(value = "findProcessInstanceList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findProcessInstanceList(ProcessInstanceVo processInstanceVo, HttpServletRequest request,
			HttpServletResponse response) {
		Page page = new EuPage(request);
		List<ProcessInstanceVo> voList = taProcessInstanceService.findProcessInstanceList(processInstanceVo, page);
		return new DataGrid(voList, page);
	}

	/**
	 * 跳转流程进展图片信息页面.
	 * <p>
	 * @param historyTaskVo
	 * @param request
	 * @param respone
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "goProcessPicInfoForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goProcessPicInfoForm(String processInstanceId, HttpServletRequest request,
			HttpServletResponse respone, Model model) {
		
		request.setAttribute("processInstanceId", processInstanceId);

		return new ModelAndView("com/biz/eisp/activiti/instance/processPicInfoForm");
	}
	
	/**
	 * 获取流程图片信息.
	 * <p>
	 * 
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping(value = "getProcessPicInfo", method = {RequestMethod.GET, RequestMethod.POST})
	public void getProcessPicInfo(HttpServletRequest request, HttpServletResponse response) throws Exception {
		response.setContentType("UTF-8");
		response.setCharacterEncoding("UTF-8");

		String processInstanceId = OConvertUtils.getString(request.getParameter("processInstanceId"));

		InputStream is = taProcessInstanceService.getProcessInstancePicInfo(processInstanceId);

		int len = 0;
		byte[] b = new byte[1024];

		while ((len = is.read(b, 0, 1024)) != -1) {
			response.getOutputStream().write(b, 0, len);
		}

	}

	/**
	 * 查询流程实例的历史任务列表.
	 * <p>
	 * 
	 * @param historyTaskVo
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "findProcessInstanceHistoryTaskList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findProcessInstanceHistoryTaskList(HistoryTaskVo historyTaskVo, HttpServletRequest request,
			HttpServletResponse response) {
//		Page page = new EuPage(request);

		List<HistoryTaskVo> voList = taProcessInstanceService.findProcessInstanceHistoryTaskList(historyTaskVo, null);

		return new DataGrid(voList, null);
	}

	/**
	 * 删除流程实例.
	 * <p>
	 * 
	 * @param myInstanceVo
	 *            我的流程实例Vo对象
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "deleteProcessInstance", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteProcessInstance(MyInstanceVo myInstanceVo, HttpServletRequest request,
			HttpServletResponse response) {
		try {
			taProcessInstanceService.deleteProcessInstance(myInstanceVo);
			
		} catch (Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
		return new AjaxJson();
	}

	/**
	 * 流程追回
	 * @author wan
	 * @param myInstanceVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "callBackProcess", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson callBackProcess(MyInstanceVo myInstanceVo, HttpServletRequest request) {
		try {
			taProcessInstanceService.callBackProcess(myInstanceVo);
		} catch (Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
		return new AjaxJson();
	}

	@RequestMapping(value = "closeProcessInstance", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson closeProcessInstance(MyInstanceVo myInstanceVo, HttpServletRequest request) {
		try {
			taProcessInstanceService.closeProcessInstance(myInstanceVo);
		} catch (Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
		return new AjaxJson();
	}
	
	/**
	 * 暂停正在运行的流程实例.
	 * <p>
	 * 
	 * @param myInstanceVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "suspend", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson suspend(MyInstanceVo myInstanceVo, HttpServletRequest request) {
		try {
			taProcessInstanceService.suspendProcessInstance(myInstanceVo);
		} catch (Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
		return new AjaxJson();
	}

	/**
	 * 启动暂停的流程实例.
	 * <p>
	 * 
	 * @param myInstanceVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "restart", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson restart(MyInstanceVo myInstanceVo, HttpServletRequest request) {
		try {
			taProcessInstanceService.activateProcessInstance(myInstanceVo);
		} catch (Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
		return new AjaxJson();
	}
	
}
