package com.biz.eisp.activiti.runtime.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.runtime.service.TaProcessManageService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;

/** 
 * 具有管理人角色权限对流程进行的处理的controller
 * <p>可以对所有正在审批过程中的流程进行：驳回到发起人、通过、删除操作
 * @author wan
 * @version v1.0
 */

@Controller
@RequestMapping("/taProcessManageController")
public class TaProcessManageController {
	
	@Autowired
	private TaProcessManageService taProcessManageService;
	
	@Autowired
	private TaTaskService taTaskService;
	
	/**
	 * 工作流管理：跳转-管理员管理流程中的流程主页
	 * @author wan
	 * @return
	 */
	@RequestMapping(value = "goTaProcessManage", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessManage(){
		return new ModelAndView("com/biz/eisp/activiti/runtime/taProcessManageMain");
	}
	
	/**
	 * 工作流管理：查询-所有正在处于审批中的流程
	 * @author wan
	 * @param myTaskVo vo对象
	 * @param request 
	 * @return
	 */
	@RequestMapping(value = "findTaProcessManageList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTaProcessManageList(MyTaskVo myTaskVo,HttpServletRequest request){
		Page page = new EuPage(request);
		List<MyTaskVo> list = taProcessManageService.findTaProcessManageList(myTaskVo,page);
		return new DataGrid(list, page);
	}
	
	/**
	 * 工作流管理：操作-驳回至发起人
	 * @author wan
	 * @param operationVo 需要传递taskId,审核意见,processInstarnceId
	 * @return
	 */
	@RequestMapping(value = "saveRejectToApply", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveRejectToApply(OperationVo operationVo){
		AjaxJson aj = new AjaxJson();
		try {
			//驳回至发起人
			taTaskService.saveRejectToApply(operationVo);
		} catch (Exception e) {
			e.printStackTrace();
			aj.setSuccess(false);
			aj.setMsg("驳回失败:"+e.getMessage());
		}
		return aj;
	}
	
	/**
	 * 工作流管理：跳转-填写驳回意见页面
	 * @author wan
	 * @param operationVo
	 * @return
	 */
	@RequestMapping(value = "goTaProcessManageRejectForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessManageRejectForm(OperationVo operationVo){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/runtime/taProcessManageRejectForm");
		view.addObject("operationVo", operationVo);
		return view;
	}
}
