package com.biz.eisp.activiti.runtime.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessFunctionAuthService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessFunctionAuthVo;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.redis.util.LockUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.runtime.service.TaProcessThemeService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.UUIDGenerator;

import java.util.List;

/** 工作流主题.
 * <p>
 * @author zkey
 * @version v1.0
 */
@Controller
@RequestMapping("/taProcessThemeController")
public class TaProcessThemeController extends BaseController{
	
	@Autowired
	private TaProcessThemeService taProcessThemeService;
	@Autowired
	private TaProcessFunctionAuthService taProcessFunctionAuthService;

	@Autowired(required = false)
	private IRedisCacheService redisService;
	/**
	 * 工作流主题：跳转-提交工作流填写主题信息
	 * @author zkey
	 * param businessKey 业务数据的ID
	 * @return
	 */
	@RequestMapping(value = "goTaProcessTheme", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessManage(HttpServletRequest request,String businessKey,String type,String fullPathName,String detail, String params){
		request.setAttribute("businessKey", businessKey);
		request.setAttribute("type", type);
		request.setAttribute("detail", detail);
		request.setAttribute("fullPathName", fullPathName);
		request.setAttribute("params", params);
		//为了解决提交多个业务{统一传递一个}
		request.setAttribute("businessKeyMain", UUIDGenerator.generate());
		return new ModelAndView("com/biz/eisp/activiti/runtime/taProcessThemeMain");
	}

	/**
	 * 工作流主题：跳转-提交工作流填写主题信息
	 * @author zkey
	 * param businessKey 业务数据的ID
	 * @return
	 */
	@RequestMapping(value = "goSelectTaProcessTheme", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goSelectTaProcessTheme(HttpServletRequest request,String businessKey,String type,String fullPathName,String detail, String params){
		request.setAttribute("businessKey", businessKey);
		request.setAttribute("type", type);
		request.setAttribute("detail", detail);
		request.setAttribute("fullPathName", fullPathName);
		request.setAttribute("params", params);

		String clickFunctionId = request.getParameter("functionId");

		List<TaProcessFunctionAuthVo> processVoList = taProcessFunctionAuthService.findTaProcessListByFunctionId(clickFunctionId);
		request.setAttribute("processVoList", processVoList);

		//为了解决提交多个业务{统一传递一个}
		request.setAttribute("businessKeyMain", UUIDGenerator.generate());
		return new ModelAndView("com/biz/eisp/activiti/runtime/selectTaProcessThemeMain");
	}

	/**
	 * 工作流主题：执行-提交工作流填写主题信息后提交
	 * @author zkey
	 * @return
	 */
	@RequestMapping(value = "doSubmit", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson doSubmit(HttpServletRequest request,HttpServletResponse response){
	   AjaxJson returnJson = new AjaxJson();
		String businessKeyMain=request.getParameter("businessKeyMain");
		if (redisService!=null&&redisService.checkAuto()) {
			LockUtils lock = new LockUtils(redisService);
			try {
				if (StringUtils.isNotBlank(businessKeyMain)) {
					boolean lock1 = lock.lock("submit_act_" + businessKeyMain);
					if (!lock1) {
						returnJson.setSuccess(false);
						returnJson.setMsg("不能重复提交");
					} else {
						returnJson = this.taProcessThemeService.doSubmit(request);
					}
				} else {
					returnJson = this.taProcessThemeService.doSubmit(request);
				}
			} catch (Exception e) {
				e.printStackTrace();
				returnJson.setSuccess(false);
				returnJson.setMsg(e.getMessage());
			} finally {
				lock.unLock("submit_act_" + businessKeyMain);
			}
		}else{
			try {
				returnJson = this.taProcessThemeService.doSubmit(request);
			} catch (Exception e) {
				e.printStackTrace();
				returnJson.setSuccess(false);
				returnJson.setMsg(e.getMessage());
			}
		}
	    return returnJson;
	 }
}
