package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.*;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.service.TtActAndAuditBillMainExtendService;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.SysConfigUtils;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import org.activiti.engine.RepositoryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 工作流任务管理.
 * <p>
 * 工作流任务相关管理： 待办任务， 历史任务， 发起的流程等
 *
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taTaskController")
public class TaTaskController extends BaseController {
    @Autowired(required = false)
    private RepositoryService repositoryService;
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaRejectRecordService taRejectRecordService;
    @Autowired(required = false)
    private TtActAndAuditBillMainExtendService ttActAndAuditBillMainExtendService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;

    @Autowired
    private SysConfigUtils sysConfigUtils;

    /**
     * 跳转到我的任务页面.
     * <p>
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "goMyTaskMain", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goMyTaskMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/myTaskMain");
    }

    /**
     * 查找我的任务列表信息.
     * <p>
     *
     * @param request
     * @param response
     * @return 我的任务MyTaskVo Vo列表信息
     */
    @RequestMapping(value = "findMyTaskList", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findMyTaskList(MyTaskVo myTaskVo, String time, HttpServletRequest request,
                                   HttpServletResponse response) {
        Page page = new EuPage(request);

        String positionCode = ResourceConfigUtils.getCurrPosition().getPositionCode();
        myTaskVo.setAssignee(positionCode);
        myTaskVo.setCreateTime(time);

        List<MyTaskVo> taskList = taTaskService.findMyTaskList(myTaskVo, page);
        return new DataGrid(taskList, page);
    }

    /**
     * 跳转到我们的历史任务页面.
     * <p>
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "goMyHistoryTaskMain", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goMyHistoryTaskMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/myHistoryTaskMain");
    }

    /**
     * 查找我的历史任务列表信息.
     * <p>
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "findMyHistoryTaskList", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findMyHistoryTaskList(HistoryTaskVo historyTaskVo, HttpServletRequest request,
                                          HttpServletResponse response) {
        Page page = new EuPage(request);
        // 设置获取当前登录者职位编码信息
        TmPositionVo tmPositionVo = ResourceConfigUtils.getCurrPosition();
        historyTaskVo.setAssignee(tmPositionVo.getPositionCode());

        List<HistoryTaskVo> taskList = taTaskService.findMyHistoryTaskList(historyTaskVo, page);
        return new DataGrid(taskList, page);
    }

    /**
     * 查找我的驳回任务列表信息.
     * <p>
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "findMyRejectTaskList", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findMyRejectTaskList(TaRejectRecordVo taRejectRecordVo, HttpServletRequest request,
                                         HttpServletResponse response) {
        Page page = new EuPage(request);
        // 设置获取当前登录者职位编码信息
        TmPositionVo tmPositionVo = ResourceConfigUtils.getCurrPosition();
        if (StringUtils.isBlank(tmPositionVo.getPositionCode())) {
            String sql = "select * from ta_reject_record t where t.id = '-1'";
            List<TaRejectRecordVo> bySql = taRejectRecordService.findBySql(TaRejectRecordVo.class, sql, page);
            return new DataGrid(bySql, page);
        }

        taRejectRecordVo.setAssignee(tmPositionVo.getPositionCode());
        List<TaRejectRecordVo> voList = taRejectRecordService.findMyRejectTaskList(taRejectRecordVo, page);
        return new DataGrid(voList, page);
    }

    /**
     * 跳转到我的任务处理页面.
     * <p>
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "goInstanceHandleTabForm",method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goInstanceHandleTabForm(MyTaskVo myTaskVo, @RequestParam("isView") boolean isView,
                                                @RequestParam("isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();
        String isCommunicate = myTaskVo.getIsCommunicate();
        String id = myTaskVo.getId();

        request.setAttribute("taskId", taskId);
        request.setAttribute("processInstanceId", processInstanceId);
        request.setAttribute("isView", isView);
        request.setAttribute("isReadFlag", isReadFlag);
        request.setAttribute("recordId", recordId);
        request.setAttribute("isCommunicate", isCommunicate);
        request.setAttribute("id", id);


        return new ModelAndView("com/biz/eisp/activiti/task/taskHandleTabForm");
    }

    /**
     * 跳转到我的任务处理页面-业务数据页面.
     * <p>
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "goTaskBusinessForm", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaskBusinessForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();

        String modelAndView = null;
        if (StringUtils.isBlank(taskId)) {
            modelAndView = taTaskService.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId());
        } else {
            modelAndView = taTaskService.getTaskBusinessForm(taskId);
        }

        // 设置流程节点页面View
        request.setAttribute(WorkFlowGlobals.PROCNODE_START, modelAndView);

        return new ModelAndView("com/biz/eisp/activiti/task/taskBusinessForm");
    }

    /**
     * 跳转到我的任务处理页面-任务处理页面.
     * <p>
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "goTaskOperateForm", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaskOperateForm(MyTaskVo myTaskVo, @RequestParam("isView") boolean isView,
                                          @RequestParam("isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();

        if (StringUtils.isBlank(processInstanceId)) {
            throw new BusinessException("流程实例ID丢失");
        }

        // 查询审批记录列表
        List<CommentVo> list = taTaskService.findActHiCommentEntity(processInstanceId);

        // 非查看模式
        if (!isView) {
            boolean hasRejectNodes = taTaskService.hasRejectNodes(taskId, processInstanceId);
            request.setAttribute("hasRejectNodes", hasRejectNodes);
            request.setAttribute("isView", isView);
        }

        request.setAttribute("taskId", taskId);
        request.setAttribute("processInstanceId", processInstanceId);
        request.setAttribute("voList", list);
        request.setAttribute("isReadFlag", isReadFlag);
        request.setAttribute("recordId", recordId);
        return new ModelAndView("com/biz/eisp/activiti/task/taskOperateForm");
    }

    /**
     * 审批通过.
     * <p>
     *
     * @param operationVo
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "saveComplete", method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveComplete(OperationVo operationVo, HttpServletRequest request, HttpServletResponse response) {
        try {
            taTaskService.saveCompelte(operationVo);
        } catch (Exception e) {
            e.printStackTrace();
            AjaxJson aj = new AjaxJson("任务处理失败：" + e.getMessage());
            aj.setSuccess(false);
            return aj;
        }
        return new AjaxJson();
    }

    /**
     * 驳回上一级.
     *
     * @param operationVo
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "saveReject", method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveReject(OperationVo operationVo, HttpServletRequest request, HttpServletResponse response) {
        try {
            taTaskService.saveReject(operationVo);
        } catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("任务处理失败：" + e.getMessage());
        }
        return new AjaxJson();
    }

    /**
     * 驳回发起人.
     *
     * @param operationVo
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "saveRejectToApply", method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveRejectToApply(OperationVo operationVo, HttpServletRequest request,
                                      HttpServletResponse response) {
        try {
            taTaskService.saveRejectToApply(operationVo);
        } catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("任务处理失败：" + e.getMessage());
        }
        return new AjaxJson();
    }


    /**
     * 标记已读.
     * <p>
     *
     * @param recordId
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "saveReadRejectStatus", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveReadRejectStatus(String recordId, HttpServletRequest request, HttpServletResponse response) {
        try {
            taRejectRecordService.updateTaRejectRecordStatus(recordId);
        } catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("任务处理失败：" + e.getMessage());
        }
        return new AjaxJson();
    }

    /**
     * 跳转至委派页面.
     * <p>
     *
     * @param myTaskVo
     * @param request
     * @return
     */
    @RequestMapping(value = "goReassignForm", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goReassignForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/reassignForm");
    }

    /**
     * 任务委派.
     * <p>
     *
     * @param myTaskVo
     * @param reassignComment
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "reassign", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson reassign(MyTaskVo myTaskVo, String reassignComment, HttpServletRequest request,
                             HttpServletResponse response) {
        try {
            String reassignPositionCode = request.getParameter("id");
            taTaskService.reassign(myTaskVo, reassignComment, reassignPositionCode);
            return new AjaxJson();
        } catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
    }

    @RequestMapping(value = "goPositionList", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goPositionList(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/positionList");
    }

    /**
     * 跳转到我的任务处理页面-审批摘要.
     * <p>
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "goTaskAbstractForm", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaskAbstractForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        //通过流程实例获取流程相关基本信息
        this.taTaskService.findProcessBasicInfoByProcinstId(myTaskVo, request);
        //获取附件信息
        this.taTaskService.findAttachmentListByProcinstId(myTaskVo.getProcessInstanceId(), request);
        return new ModelAndView("com/biz/eisp/activiti/task/taskAbstractForm");
    }

    /**
     * 跳转到我的任务处理页面-审批详情.
     * <p>
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "goTaskDetailForm", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaskDetailForm(MyTaskVo myTaskVo, HttpServletRequest request, @RequestParam("isView") boolean isView) {
        request.setAttribute("taskId", myTaskVo.getTaskId());
        request.setAttribute("processInstanceId", myTaskVo.getProcessInstanceId());
        request.setAttribute("businessKey", taTaskService.getBusinessFormByProcessInstanceId(myTaskVo.getProcessInstanceId()).getBusinessObjId());
        request.setAttribute("currPositionCode", ResourceConfigUtils.getCurrPosition().getPositionCode());
        request.setAttribute("isReadFlag", request.getParameter("isReadFlag"));
        if ("Y".equals(myTaskVo.getIsCommunicate())) {
            isView = true;
            TaCommunicateContentEntity communicateEntity = taTaskService.get(TaCommunicateContentEntity.class, myTaskVo.getId());
            request.setAttribute("communicateContent", communicateEntity.getContent());
            request.setAttribute("communicateId", communicateEntity.getId());
        }
        request.setAttribute("isView", isView);
        request.setAttribute("isCommunicate", myTaskVo.getIsCommunicate());
        boolean extendServiceFlag = true;
        if (StringUtil.isEmpty(ttActAndAuditBillMainExtendService)) {
            extendServiceFlag = false;
        }
        request.setAttribute("extendServiceFlag", extendServiceFlag);
        if (!isView) {
            boolean hasRejectNodes = taTaskService.hasRejectNodes(myTaskVo.getTaskId(), myTaskVo.getProcessInstanceId());
            request.setAttribute("hasRejectNodes", hasRejectNodes);

            //获取可以驳回的节点
            this.taTaskService.findRejectNode(myTaskVo.getTaskId(), myTaskVo.getProcessInstanceId(), request);
        }
        //关键指标
//		this.taTaskService.findKeyIndicators(myTaskVo, request);
        this.setKeyIndicators(myTaskVo, request);

        //审批日志
        this.taTaskService.findApprovalLogs(myTaskVo, request);

        //通过流程实例获取流程相关基本信息
        this.taTaskService.findProcessBasicInfoByProcinstId(myTaskVo, request);
        //获取附件信息
        this.taTaskService.findAttachmentListByProcinstId(myTaskVo.getProcessInstanceId(), request);

        //设置是否隐藏业务附件信息
        request.setAttribute("hiddenAttachment", sysConfigUtils.getHiddenAttachment());
        //request.setAttribute("hiddenAttachment", ResourceUtil.getSysConfigProperty("hiddenAttachment"));

        //设置是否开启隐藏功能
        String showHideButtom = sysConfigUtils.getShowHideButtom();
        //String showHideButtom = ResourceUtil.getSysConfigProperty("showHideButtom");
        request.setAttribute("showHideButtom", showHideButtom == null ? "N" : showHideButtom);

        //设置节点按钮权限
        taTaskService.setNodeAuth(myTaskVo, request);

        return new ModelAndView("com/biz/eisp/activiti/task/taskDetailForm");
    }

    //设置关键业务指标
    private void setKeyIndicators(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();

        String modelAndView = null;
        if (StringUtils.isBlank(taskId)) {
            modelAndView = taTaskService.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId());
        } else {
            modelAndView = taTaskService.getTaskBusinessForm(taskId);
        }

        if (modelAndView != null) {
            modelAndView += "&isKeyIndicators=true";
        }

        // 设置流程节点页面View
        request.setAttribute(WorkFlowGlobals.PROCNODE_START, modelAndView);
    }
}
