package com.biz.eisp.activiti.runtime.dao;

import java.util.List;

import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyPersonInfoVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author wan
 * @version v1.0
 */
@InterfaceDao
public interface TaCarbonCopyDao {
	/**
	 * 查询抄送和传阅，在首页一起
	 * @author wan
	 * @param page
	 * @return
	 */
	@Arguments({"query","page"})
	@ResultType(TaCopyCirculationVo.class)
	public List<TaCopyCirculationVo> findCarbonCopyAndCirculationList(TaCopyCirculationVo query,Page page);
	/**
	 * 查询抄送和传阅，在首页一起
	 * @author wan
	 * @param page
	 * @return
	 */
	@Arguments({"query","page"})
	@ResultType(TaCopyCirculationVo.class)
	public List<TaCopyCirculationVo> findCarbonCopyAndCirculation(TaCopyCirculationVo query,Page page);
	
	/**
	 * 查询传阅，根据id
	 * @author wan
	 * @param query
	 * @return
	 */
	@Arguments({"query"})
	@ResultType(TaCopyCirculationVo.class)
	public List<TaCopyCirculationVo> findCirculationById(TaCopyCirculationVo query);

	/**
	 * 查询抄送人员信息列表页面
	 * @param vo
	 * @param page
	 * @return
	 */
	@Arguments({"vo", "page"})
	@ResultType(TaCopyPersonInfoVo.class)
	public List<TaCopyPersonInfoVo> findCopyPersonInfoList(TaCopyPersonInfoVo vo, Page page);
	
}
