package com.biz.eisp.activiti.runtime.dao;

import java.util.List;

import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.biz.eisp.activiti.runtime.vo.ProcessInstanceVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;

/**
 * 类简述.
 * <p>
 * 类的详细说明第一行<br>
 * 类的详细说明第二行
 * 
 * @author liukai
 * @version v1.0
 */
@InterfaceDao
public interface TaProcessInstanceDao {

	/**
	 * 查询我发起的流程.
	 * <p>
	 * 
	 * @param myInstanceVo
	 *            我的流程Vo对象
	 * @param page
	 *            页面对象
	 * @return
	 */
	@ResultType(MyInstanceVo.class)
	@Arguments({ "myInstanceVo", "page" })
	public List<MyInstanceVo> findMyStartedProcessList(MyInstanceVo myInstanceVo, Page page);

	/**
	 * 查询流程实例信息列表.
	 * <p>
	 * 
	 * @param processInstanceVo
	 * @param page
	 * @return 
	 */
	@ResultType(ProcessInstanceVo.class)
	@Arguments({ "processInstanceVo", "page" })
	public List<ProcessInstanceVo> findProcessInstanceList(ProcessInstanceVo processInstanceVo, Page page);
}
