package com.biz.eisp.activiti.runtime.dao;

import java.util.List;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.CommentVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.TaProcessApprovalLogVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;

/**
 * 任务管理Dao接口.
 * <p>
 *
 * @author liukai
 * @version v1.0
 */
@InterfaceDao
public interface TaTaskDao {

	/**
	 * 查询我的任务（待办任务）列表.
	 * <p>
	 * 
	 * @param myTaskVo
	 *            我的任务Vo对象
	 * @param page
	 *            页面对象
	 * @return
	 */
	@ResultType(MyTaskVo.class)
	@Arguments({ "myTaskVo", "page" })
	public List<MyTaskVo> findMyTaskList(MyTaskVo myTaskVo, Page page);

	/**
	 * 查询我的历史任务（已办任务）列表.
	 * <p>
	 * 
	 * @param myTaskVo
	 *            我的任务Vo对象
	 * @param page
	 *            页面对象
	 * @return
	 */
	@ResultType(HistoryTaskVo.class)
	@Arguments({ "historyTaskVo", "page" })
	public List<HistoryTaskVo> findMyHistoryTaskList(HistoryTaskVo historyTaskVo, Page page);

	/**
	 * 根据taskId获取业务对象ID.
	 * <p>
	 * 
	 * @param taskId
	 * @return
	 */
	public String getBusinessObjIdByTaskId(String taskId);
	
	@ResultType(CommentVo.class)
	@Arguments({ "processInstanceId", "businessObjId"}) 
	public List<CommentVo> findProcessInstanceCommentList(String processInstanceId, String businessObjId);
	
	/**
	 * 查询审批历史
	 * @author wan
	 * @param businessObjId
	 * @return
	 */
	@ResultType(CommentVo.class)
	@Arguments({"businessObjId"})
	public List<CommentVo> findProcessInstanceCommentByBusinessKey(String businessObjId);
	
	@ResultType(CommentVo.class)
	@Arguments({ "taskId"})  
	public BusinessFormVo getBusinessForm(String taskId);
	
	@ResultType(CommentVo.class)
	@Arguments({ "processInstanceId"})  
	public BusinessFormVo getBusinessFormByProcessInstanceId(String processInstanceId);
	
	@ResultType(MyTaskVo.class)
	@Arguments({ "myTaskVo", "page"})   
	public List<MyTaskVo> findMyRejectTaskList(MyTaskVo myTaskVo, Page page);

	@ResultType(MyTaskVo.class)
	@Arguments({ "processInstanceId"}) 
	public MyTaskVo findProcessBasicInfoByProcinstId(String processInstanceId);

	@ResultType(TaProcessApprovalLogVo.class)
	@Arguments({ "processInstanceId"}) 
	public List<TaProcessApprovalLogVo> findLog(String processInstanceId);

	@ResultType(TaProcessNodeEntity.class)
	@Arguments({ "processInstanceId","nodeStr"})
	public List<TaProcessNodeEntity> findLogForNoApproval(String processInstanceId,String nodeStr);

	/**
	 * 查询当前待审批节点
	 * @param processInstanceId 流程实例id
	 * @return
	 */
	@ResultType(TaProcessApprovalLogVo.class)
	@Arguments({ "processInstanceId"})
	public List<TaProcessApprovalLogVo> findRuntimeApprovalList(String processInstanceId);
}
