package com.biz.eisp.activiti.runtime.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.model.activiti.Process;
import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;

/**
 * 业务父类表,如需走流程引擎的业务须继承该表.
 * <p>
 * 业务父类表,如需走流程引擎的业务须继承该表. TaBusinessObjEntity（ta_business_obj）中的实体应该继承于此实体
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "ta_base_business_obj")
@Inheritance(strategy = InheritanceType.JOINED)
public class TaBaseBusinessObjEntity extends IdEntity implements java.io.Serializable {
	private static final long serialVersionUID = 1L;
	
	// 创建职位
	private TmPositionEntity tmPositionEntity;
	// 业务类型
	private TmDictTypeEntity tmDictTypeEntity;
	// 创建时间
	private Date createtime;
	// 业务自定义状态表
	private TaRuntimeStatusEntity taRuntimeStatusEntity;
	// 工作流引擎实例模型
	private Process process = new Process();
	// 业务配置表
	private TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity = new TaProcessBusinessObjConfigEntity();
	// 业务流程标题
	private String processTitle;
	private String userName;
	private String fullName;
	private String positionCode;
	private String positionName;
	private Integer readRejectStatus;
	private String processDetail;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "position_id")
	public TmPositionEntity getTmPositionEntity() {
		return tmPositionEntity;
	}

	public void setTmPositionEntity(TmPositionEntity tmPositionEntity) {
		this.tmPositionEntity = tmPositionEntity;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "type_id")
	public TmDictTypeEntity getTmDictTypeEntity() {
		return tmDictTypeEntity;
	}

	public void setTmDictTypeEntity(TmDictTypeEntity tmDictTypeEntity) {
		this.tmDictTypeEntity = tmDictTypeEntity;
	}

	@Column(name = "CREATE_TIME", nullable = false, length = 20)
	public Date getCreatetime() {
		return createtime;
	}

	public void setCreatetime(Date createtime) {
		this.createtime = createtime;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "runtime_status_id")
	public TaRuntimeStatusEntity getTaRuntimeStatusEntity() {
		return taRuntimeStatusEntity;
	}

	public void setTaRuntimeStatusEntity(TaRuntimeStatusEntity taRuntimeStatusEntity) {
		this.taRuntimeStatusEntity = taRuntimeStatusEntity;
	}

	@Transient
	public Process getProcess() {
		return process;
	}

	public void setProcess(Process process) {
		this.process = process;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "process_busiobj_config_id")
	public TaProcessBusinessObjConfigEntity getTaProcessBusinessObjConfigEntity() {
		return taProcessBusinessObjConfigEntity;
	}

	public void setTaProcessBusinessObjConfigEntity(TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity) {
		this.taProcessBusinessObjConfigEntity = taProcessBusinessObjConfigEntity;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	@Column(name = "PROCESS_TITLE", length = 100)
	public String getProcessTitle() {
		return processTitle;
	}

	public void setProcessTitle(String processTitle) {
		this.processTitle = processTitle;
	}

	@Column(name = "USER_NAME", length = 50)
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	@Column(name = "FULL_NAME", length = 50)
	public String getFullName() {
		return fullName;
	}

	public void setFullName(String fullName) {
		this.fullName = fullName;
	}

	@Column(name = "POSITION_CODE", length = 50)
	public String getPositionCode() {
		return positionCode;
	}

	public void setPositionCode(String positionCode) {
		this.positionCode = positionCode;
	}

	@Column(name = "POSITION_NAME", length = 50)
	public String getPositionName() {
		return positionName;
	}

	public void setPositionName(String positionName) {
		this.positionName = positionName;
	}

	@Column(name = "READ_REJECT_STATUS")
	public Integer getReadRejectStatus() {
		return readRejectStatus;
	}

	public void setReadRejectStatus(Integer readRejectStatus) {
		this.readRejectStatus = readRejectStatus;
	}
	
	@Column(name = "PROCESS_DETAIL")
	public String getProcessDetail() {
		return processDetail;
	}

	public void setProcessDetail(String processDetail) {
		this.processDetail = processDetail;
	}
}
