package com.biz.eisp.activiti.runtime.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;

/** 
 * 抄送配置实体
 * @author wan
 * @version v1.0
 */
@Entity
@Table(name = "ta_carboncopy")
public class TaCarbonCopyEntity extends IdEntity implements Serializable{
	private static final long serialVersionUID = 3460527215422679034L;
	
	//流程id
	private String taProcessId;
	//流程key
	private String taProcessKey;
	//状态0:user(角色) 1：position(职位)
	private String state;
	//1组织，2组织及组织以下，0职位
	private String chooseCondition;
	//抄送人编码
	private String code;
	//抄送人名称
	private String name;
	//创建时间
	private Date createDate;
	//创建人
	private String createName;
	//更新时间
	private Date updateDate;
	//更新人
	private String updateName;
	
	@Column(name = "ta_process_id")
	public String getTaProcessId() {
		return taProcessId;
	}
	@Column(name = "ta_process_key")
	public String getTaProcessKey() {
		return taProcessKey;
	}
	@Column(name = "code")
	public String getCode() {
		return code;
	}
	@Column(name = "name",length = 32)
	public String getName() {
		return name;
	}
	@Column(name = "choose_condition",length = 5)
	public String getChooseCondition() {
		return chooseCondition;
	}
	@Column(name = "state",length = 5)
	public String getState(){
		return state;
	}
	@Column(name = "create_date")
	public Date getCreateDate() {
		return createDate;
	}
	@Column(name = "create_name",length = 32)
	public String getCreateName() {
		return createName;
	}
	@Column(name = "update_date")
	public Date getUpdateDate() {
		return updateDate;
	}
	@Column(name = "update_name",length = 32)
	public String getUpdateName() {
		return updateName;
	}
	/**************************************************/
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	public void setState(String state) {
		this.state = state;
	}
	public void setChooseCondition(String chooseCondition) {
		this.chooseCondition = chooseCondition;
	}
	public void setTaProcessId(String taProcessId) {
		this.taProcessId = taProcessId;
	}
	public void setTaProcessKey(String taProcessKey) {
		this.taProcessKey = taProcessKey;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public void setName(String name) {
		this.name = name;
	}
}
