package com.biz.eisp.activiti.runtime.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;

/** 
 * 传阅表
 * @author wan
 * @version v1.0
 */
@Entity
@Table(name = "ta_circulation")
public class TaCirculationEntity extends IdEntity implements Serializable{
	private static final long serialVersionUID = 3086302332297044061L;

	//业务实体
	private String businessKey;
	//实例主键
	private String processInstanceId;
	//流程名称
	private String processName;
	//流程key
	private String processKey;
	//单据名称
	private String processTitle;
	//传阅发起人职位编码
	private String launchCode;
	//传阅发起人职位名称
	private String launchName;
	
	private Date createDate;
	private String createName;
	private Date updateDate;
	private String updateName;
	
	//流程创建人名称
	private String createProcessPositionName;
	//流程创建人编码
	private String createProcessPositionCode;
	
	@Column(name = "launch_code")
	public String getLaunchCode() {
		return launchCode;
	}
	@Column(name = "launch_name")
	public String getLaunchName() {
		return launchName;
	}
	@Column(name = "business_key")
	public String getBusinessKey() {
		return businessKey;
	}
	@Column(name = "process_instance_id")
	public String getProcessInstanceId() {
		return processInstanceId;
	}
	@Column(name = "process_name")
	public String getProcessName() {
		return processName;
	}
	@Column(name = "process_key")
	public String getProcessKey() {
		return processKey;
	}
	
	@Column(name = "process_title")
	public String getProcessTitle() {
		return processTitle;
	}
	@Column(name = "create_date")
	public Date getCreateDate() {
		return createDate;
	}
	@Column(name = "update_date")
	public Date getUpdateDate() {
		return updateDate;
	}
	@Column(name = "create_name")
	public String getCreateName() {
		return createName;
	}
	@Column(name = "update_name")
	public String getUpdateName() {
		return updateName;
	}
	@Column(name = "create_process_position_name")
	public String getCreateProcessPositionName() {
		return createProcessPositionName;
	}
	@Column(name = "create_process_position_code")
	public String getCreateProcessPositionCode() {
		return createProcessPositionCode;
	}
	
	
	public void setCreateProcessPositionName(String createProcessPositionName) {
		this.createProcessPositionName = createProcessPositionName;
	}
	public void setCreateProcessPositionCode(String createProcessPositionCode) {
		this.createProcessPositionCode = createProcessPositionCode;
	}
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	public void setBusinessKey(String businessKey) {
		this.businessKey = businessKey;
	}
	public void setProcessInstanceId(String processInstanceId) {
		this.processInstanceId = processInstanceId;
	}
	public void setProcessName(String processName) {
		this.processName = processName;
	}
	public void setProcessKey(String processKey) {
		this.processKey = processKey;
	}
	public void setProcessTitle(String processTitle) {
		this.processTitle = processTitle;
	}
	public void setLaunchCode(String launchCode) {
		this.launchCode = launchCode;
	}
	public void setLaunchName(String launchName) {
		this.launchName = launchName;
	}
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
}
