package com.biz.eisp.activiti.runtime.entity;

import com.biz.eisp.base.common.identity.IdEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;


/** 
 * 沟通内容表
 * @author wan
 * @version v1.0
 */
@Entity
@Table(name = "ta_communicate_content")
public class TaCommunicateContentEntity extends IdEntity implements Serializable{
	private static final long serialVersionUID = -4611884719888651654L;
	
	//沟通主表主键
	private String taCommunicateId;
	//沟通接收编码
	private String circulationCode;
	//沟通接收名称
	private String circulationName;
	//沟通内容
	private String content;
	//接收内容
	private String reciveContent;
	//查阅状态，关于首页是否显示
	private String viewStatus;
	/**
	 * 阅读状态：
	 * 传阅出去的内容，必须别人有回复了内容，才会更新该字段
	 */
	private String readStatus;
	//是否可回复消息 0可以 1不可
	private String isReply;
	
	private Date createDate;
	private String createName;
	private Date updateDate;
	private String updateName;

	/**
	 * 强制答复标记，Y：要进行强制答复，N不用进行强制答复
	 */
	private String forceReplyFlag;

	@Column(name = "ta_communicate_id")
	public String getTaCommunicateId() {
		return taCommunicateId;
	}

	public void setTaCommunicateId(String taCommunicateId) {
		this.taCommunicateId = taCommunicateId;
	}

	@Column(name = "content")
	public String getContent() {
		return content;
	}
	@Column(name = "recive_content")
	public String getReciveContent() {
		return reciveContent;
	}
	@Column(name = "create_date")
	public Date getCreateDate() {
		return createDate;
	}
	@Column(name = "update_date")
	public Date getUpdateDate() {
		return updateDate;
	}
	@Column(name = "create_name")
	public String getCreateName() {
		return createName;
	}
	@Column(name = "update_name")
	public String getUpdateName() {
		return updateName;
	}
	@Column(name = "is_reply")
	public String getIsReply() {
		return isReply;
	}
	@Column(name = "circulation_code")
	public String getCirculationCode() {
		return circulationCode;
	}
	@Column(name = "circulation_name")
	public String getCirculationName() {
		return circulationName;
	}
	@Column(name = "view_status")
	public String getViewStatus() {
		return viewStatus;
	}
	@Column(name = "read_status")
	public String getReadStatus() {
		return readStatus;
	}
	
	public void setCirculationCode(String circulationCode) {
		this.circulationCode = circulationCode;
	}
	public void setCirculationName(String circulationName) {
		this.circulationName = circulationName;
	}
	public void setViewStatus(String viewStatus) {
		this.viewStatus = viewStatus;
	}
	public void setIsReply(String isReply) {
		this.isReply = isReply;
	}
	public void setReadStatus(String readStatus) {
		this.readStatus = readStatus;
	}
	public void setContent(String content) {
		this.content = content;
	}
	public void setReciveContent(String reciveContent) {
		this.reciveContent = reciveContent;
	}
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}

	@Column(name = "FORCE_REPLY_FLAG")
	public String getForceReplyFlag() {
		return forceReplyFlag;
	}

	public void setForceReplyFlag(String forceReplyFlag) {
		this.forceReplyFlag = forceReplyFlag;
	}
}
