package com.biz.eisp.activiti.runtime.entity;

import com.biz.eisp.base.common.identity.IdEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 节点指点跳转信息表
 * Created by liukai on 2017/7/24.
 */
@Entity
@Table(name = "ta_jump_node")
public class TaJumpNodeEntity extends IdEntity implements Serializable {
    /**
     * 原节点编码
     */
    private String srcTaskKey;
    /**
     * 目标节点编码
     */
    private String targetTaskKey;
    /**
     * 流程实例id
     */
    private String processInstanceId;
    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 创建人
     */
    private String createName;

    @Column(name = "SRC_TASK_KEY")
    public String getSrcTaskKey() {
        return srcTaskKey;
    }

    public void setSrcTaskKey(String srcTaskKey) {
        this.srcTaskKey = srcTaskKey;
    }

    @Column(name = "TARGET_TASK_KEY")
    public String getTargetTaskKey() {
        return targetTaskKey;
    }

    public void setTargetTaskKey(String targetTaskKey) {
        this.targetTaskKey = targetTaskKey;
    }

    @Column(name = "PROCESS_INSTANCE_ID")
    public String getProcessInstanceId() {
        return processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    @Column(name = "create_date")
    public Date getCreateDate() {
        return createDate;
    }

    @Column(name = "create_name")
    public String getCreateName() {
        return createName;
    }

}
