package com.biz.eisp.activiti.runtime.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;

/**
 * @Desc 审批日志表
 *
 * @Author zkey
 * @Date 2017年4月6日 上午11:02:59
 * @Version 1.0
 */
@Entity
@Table(name = "ta_process_approval_log")
public class TaProcessApprovalLogEntity extends IdEntity implements Serializable{
	private static final long serialVersionUID = 566987725957308594L;
	
	private Date createDate;
	
	private String account; //审批人账号
	
	private String name; //审批人姓名
	
	private Integer type; //类型
	
	private String content; //审批意见
	
	private String processInstId; //流程实例Id
	
	private String taskDefKey;//任务定义key
	private String positionCode; //职位编码
	private String positionName; //职位名称

	@Column(name="create_date")
	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	@Column(name="account")
	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}
	@Column(name="name")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	@Column(name="type")
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
	@Column(name="content")
	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
	@Column(name="process_inst_id")
	public String getProcessInstId() {
		return processInstId;
	}

	public void setProcessInstId(String processInstId) {
		this.processInstId = processInstId;
	}
	@Column(name="task_def_key",nullable = true)
	public String getTaskDefKey() {
		return taskDefKey;
	}

	public void setTaskDefKey(String taskDefKey) {
		this.taskDefKey = taskDefKey;
	}

	@Column(name="position_code")
	public String getPositionCode() {
		return positionCode;
	}

	public void setPositionCode(String positionCode) {
		this.positionCode = positionCode;
	}

	@Column(name="position_name")
	public String getPositionName() {
		return positionName;
	}

	public void setPositionName(String positionName) {
		this.positionName = positionName;
	}
}
