package com.biz.eisp.activiti.runtime.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;

/**
 * 业务流程状态表.
 * <p>
 * 业务开展过程中的状态表
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "ta_runtime_status")
public class TaRuntimeStatusEntity extends IdEntity implements java.io.Serializable {

	// 状态值
	private String status;
	// 状态描述 (新建,办理中,结束)
	private String description;  
	// 状态唯一编码
	private String code;
	// 状态简称
	private String name;
	// 执行角色
	private String executeRole;
	// 下一步操作的角色
	private String nextStepRole;

	@Column(name = "execute_role", length = 100)
	public String getExecuteRole() {
		return executeRole;
	}

	public void setExecuteRole(String executeRole) {
		this.executeRole = executeRole;
	}

	@Column(name = "next_step_role", length = 100)
	public String getNextStepRole() {
		return nextStepRole;
	}

	public void setNextStepRole(String nextStepRole) {
		this.nextStepRole = nextStepRole;
	}

	@Column(name = "status", length = 100)
	public String getStatus() {
		return this.status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Column(name = "description", length = 300)
	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name = "code", length = 50)
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Column(name = "name", length = 50)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

}
