package com.biz.eisp.activiti.runtime.service;

import java.util.List;

import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyPersonInfoVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

/**
 * 抄送功能的service
 * @author wan
 * @version v1.0
 */
public interface TaCarbonCopyService extends BaseService{
	
	/**
	 * 抄送配置：查询-根据流程key查询配置信息
	 * @author wan
	 * @param taProcessKey
	 * @return
	 */
	public List<TaCarbonCopyVo> getAllByProcessKey(String taProcessKey);
	
	/**
	 * 抄送配置：查询-根据查询条件，查询抄送列表
	 * @author wan
	 * @param vo
	 * @param page
	 * @return
	 */
	public List<TaCopyCirculationVo> getCarbonCopyByConditions(TaCopyCirculationVo vo,Page page);
	
	/**
	 * 抄送配置：保存-抄送配置
	 * @author wan
	 * @param sendType
	 * @param taProcessId
	 * @param codes
	 * @param names
	 * @param chooseCondition
	 */
	public AjaxJson saveCarbonCopy(TaCarbonCopyVo vo);
	
	/**
	 * 抄送配置：保存-传阅
	 * @author wan
	 * @return
	 */
	public void saveCirculation(String processInstanceId,String codes,String names, String fullNames,String content);
	
	/**
	 * 抄送配置：删除-抄送配置
	 * @param taskId
	 * @param taProcessId
	 */
	public void delCarbonCopyById(String ids);
	
	/**
	 * 抄送配置：查询-首页数据
	 * @author wan
	 * @param vo
	 * @param time
	 * @param page
	 * @return
	 */
	public List<TaCopyCirculationVo> findCopyAndCirculation(TaCopyCirculationVo vo,Page page);
	
	/**
	 * 抄送配置：查询-已配置的抄送角色/职位
	 * @author wan
	 * @param vo
	 * @param page
	 * @return
	 */
	public List<TaCarbonCopyVo> findTaCarbonCopy(TaCarbonCopyVo vo,Page page);

	/**
	 * 查询抄送人员信息列表页面
	 * @param vo
	 * @param page
	 * @return
	 */
	public List<TaCopyPersonInfoVo> findCopyPersonInfoList(TaCopyPersonInfoVo vo, Page page);
}
