package com.biz.eisp.activiti.runtime.service;


import java.util.List;

import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;

/**
 * 抄送/传阅 查看详情service
 * @author wan
 * @version v1.0
 */
public interface TaHandCopyAndCirculationService{
	
	/**
	 * 抄送传阅：查询-获取该业务key的数据页面地址
	 * @author wan
	 * @param businessKey 业务相关连的key
	 * @return
	 */
	public String getCopyAndCirculationBusinessForm(String piId,String businessKey);
	
	/**
	 * 抄送传阅：更新-抄送/传阅的viewStatus查阅状态值
	 * @author wan
	 * @param vo vo对象
	 */
	public void updateCarbonOrCirculationState(TaCopyCirculationVo vo);
	
	/**
	 * 抄送传阅：查询-抄送/传阅 详情
	 * @author wan
	 * @return
	 */
	public List<TaCopyCirculationVo> findCirculationMessage(TaCopyCirculationVo query);
	
	/**
	 * 抄送传阅：保存-传阅回执的内容
	 * @author wan
	 * @param id 传阅主表Id
	 * @param content 传阅回执内容
	 */
	public void saveCirculationContent(String id,String content);
}
