package com.biz.eisp.activiti.runtime.service;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;

import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.biz.eisp.activiti.runtime.vo.ProcessInstanceVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

/**
 * 流程实例管理Service接口.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public interface TaProcessInstanceService extends BaseService {

	/**
	 * 启动工作流.
	 * @param processKey 工作流流程key
	 * @param positionCode 发起人职位编码
	 * @param businessKey 业务id
	 * @param variables 变量
	 */
	public void saveStartWorkflow(String processKey, String positionCode, String businessKey, Map<String, Object> variables);
	/**
	 * 启动工作流.
	 * @param taBaseBusinessObjEntity
	 * @param businessObjId 业务对象ID
	 * @param variables  变量 MAP
	 * @param tsBusbase 业务对象与流程信息对象配置
	 * @return
	 */
	public ProcessInstance saveStartWorkflow(TaBaseBusinessObjQueryEntity taBaseBusinessObjEntity, String businessObjId,Map<String, Object> variables,TaProcessBusinessObjConfigEntity tsBusbase);
	/**
	 * 启动工作流.
	 * 启动工作流，保存启动工作流操作
	 * @param taProcessBusinessObjConfigVo
	 */
	public void saveStartWorkflow(TaProcessBusinessObjConfigVo taProcessBusinessObjConfigVo);
	/**
	 * 启动工作流
	 * 启动工作流，该方法运用在保存数据之后立即启动流程
	 * @author wan
	 * @param configVo 配置
	 * @param baseEntity 业务父表
	 */
	public void saveStartWorkflow(TaProcessBusinessObjConfigVo configVo,TaBaseBusinessObjEntity baseEntity);
	/**
	 * 启动工作流
	 * 配合在保存数据之后立即启动的方法
	 * @author wan
	 * @param baseEntity 业务父表
	 * @param variables 变量
	 * @param configEntity 配置实体
	 * @return
	 */
	public ProcessInstance saveStartWorkflow(TaBaseBusinessObjEntity baseEntity,Map<String, Object> variables,TaProcessBusinessObjConfigEntity configEntity);
	
	/**
	 * 查询我发起的流程信息列表.
	 * <p>
	 * 
	 * @param myInstatnceVo
	 *            我的流程实例VO对象
	 * @param page
	 *            页面对象
	 * @return
	 */
	public List<MyInstanceVo> findMyStartedProcessList(MyInstanceVo myInstatnceVo, Page page);

	/**
	 * 查询流程实例信息列表.
	 * <p>
	 * 
	 * @param processInstanceVo
	 * @param page
	 * @return
	 */
	public List<ProcessInstanceVo> findProcessInstanceList(ProcessInstanceVo processInstanceVo, Page page);

	public String getProcessInstanceIdByTaskId(String taskId);

	/**
	 * 获取流程实例图片信息.
	 * <p>
	 * 
	 * @param processInstanceId
	 *            流程实例ID
	 * @return
	 */
	public InputStream getProcessInstancePicInfo(String processInstanceId);

	/**
	 * 查询流程实例历史任务列表.
	 * <p>
	 * 
	 * @param historyTaskVo
	 *            历史任务Vo对象
	 * @param page
	 *            页面对象
	 * @return
	 */
	public List<HistoryTaskVo> findProcessInstanceHistoryTaskList(HistoryTaskVo historyTaskVo, Page page);

	/**
	 * 查询流程实例流程图走向（位置）列表.
	 * <p>
	 * 
	 * @param processInstanceId
	 *            流程实例ID
	 * @return
	 */
	public List<ActivityImpl> findDiagramPositionList(String processInstanceId);

	/**
	 * 删除流程实例对象.
	 * <p>
	 * 
	 * @param myInstanceVo
	 */
	public void deleteProcessInstance(MyInstanceVo myInstanceVo);

	/**
	 * 发起人追回流程.
	 * <p>
	 * 
	 * @param myInstanceVo
	 */
	public void callBackProcess(MyInstanceVo myInstanceVo);

	/**
	 * 流程关闭.
	 * <p>
	 * 
	 * @param myInstanceVo
	 */
	public void closeProcessInstance(MyInstanceVo myInstanceVo);

	/**
	 * 暂停流程实例.
	 * <p>
	 * 
	 * @param myInstanceVo
	 *            我的流程Vo对象
	 */
	public void suspendProcessInstance(MyInstanceVo myInstanceVo);

	/**
	 * 激活流程实例.
	 * <p>
	 * 
	 * @param myInstanceVo
	 *            我的流程Vo对象
	 */
	public void activateProcessInstance(MyInstanceVo myInstanceVo);
}
