package com.biz.eisp.activiti.runtime.service;

import java.util.List;

import com.biz.eisp.activiti.runtime.vo.TaRejectRecordVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

/**
 * 驳回数据记录CURD .
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public interface TaRejectRecordService extends BaseService {

	/**
	 * 保存驳回记录数据.
	 * <p>
	 * 
	 * @param processInstanceId
	 *            流程实例id
	 */
	public void saveTaRejectRecord(String processInstanceId);
	/**
	 * 保存驳回记录数据-手机.
	 * <p>
	 * 
	 * @param processInstanceId
	 *            流程实例id
	 * @param positionId
	 * 			  职位id
	 */
	public void saveTaRejectRecord(String processInstanceId,String positionId);

	/**
	 * 查询驳回记录列表.
	 * <p>
	 * 
	 * @param taRejectRecordVo
	 * @param page
	 * @return
	 */
	public List<TaRejectRecordVo> findMyRejectTaskList(TaRejectRecordVo taRejectRecordVo, Page page);

	/**
	 * 修改驳回记录信息.
	 * <p>
	 * @param processInstanceId
	 */
	public void updateTaRejectRecordStatus(String id);
}
