package com.biz.eisp.activiti.runtime.service;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.activiti.runtime.vo.*;
import org.activiti.engine.task.Task;

import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

/**
 * 任务管理Service实现.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public interface TaTaskService extends BaseService {

	/**
	 * 查看我的待办任务列表.
	 * <p>
	 * 
	 * @param myTaskVo
	 *            我的任务Vo 必须设置
	 * @param page
	 *            页面对象
	 * @return Vo对象列表信息
	 */
	public List<MyTaskVo> findMyTaskList(MyTaskVo myTaskVo, Page page);

	/**
	 * 查看我的历史任务列表.
	 * <p>
	 * 
	 * @param userName
	 *            用户名
	 * @param page
	 *            页面对象
	 * @return
	 */
	public List<HistoryTaskVo> findMyHistoryTaskList(HistoryTaskVo historyTaskVo, Page page);

	/**
	 * 查询实例历史任务列表.
	 * <p>
	 * 
	 * @param historyTaskVo
	 *            历史任务Vo
	 * @param page
	 *            页面对象
	 * @return
	 */
	public List<HistoryTaskVo> findProcessInstanceTaskHistoryList(HistoryTaskVo historyTaskVo, Page page);

	/**
	 * 获取该任务的业务数据页面地址.
	 * <p>
	 * 
	 * @param taskId
	 *            任务ID
	 * @return url地址
	 */
	public String getTaskBusinessForm(String taskId);

	/**
	 * 获取流程实例业务表单地址.
	 * <p>
	 * 
	 * @param processInstanceId
	 *            流程实例ID
	 * @return
	 */
	public String getProcessInstanceBusinessForm(String processInstanceId);

	/**
	 * 获取任务对象.
	 * <p>
	 * 
	 * @param taskId
	 *            任务id
	 * @return
	 */
	public Task getTask(String taskId);

	/**
	 * 根据任务获取业务对象Id.
	 * <p>
	 * 
	 * @param task
	 * @return
	 */
	public String getBusinessObjIdByTask(Task task);

	/**
	 * 保存签收操作.
	 * <p>
	 * 
	 * @param myTaskVo
	 */
	public void saveClaim(MyTaskVo myTaskVo);

	/**
	 * 保存完成操作.
	 * <p>
	 * 
	 * @param myTaskVo
	 */
	public void saveComplete(MyTaskVo myTaskVo);

	/**
	 * 审批通过.
	 * <p>
	 * 
	 * @param operationVo
	 *            操作Vo对象
	 */
	public void saveCompelte(OperationVo operationVo);

	/**
	 * 驳回（驳回上一级）.
	 * <p>
	 * 
	 * @param operationVo
	 *            操作Vo对象
	 */
	public void saveReject(OperationVo operationVo);

	/**
	 * 根据processInstanceId判断是否流程结束.
	 * <p>
	 * 
	 * @param processInstanceId
	 *            流程实例id
	 * @return
	 */
	public boolean isLastTask(String processInstanceId);

	/**
	 * 驳回发起人.
	 * <p>
	 * 
	 * @param operationVo
	 *            操作Vo对象
	 */
	public void saveRejectToApply(OperationVo operationVo);
	/**
	 * 驳回发起人-手机.
	 * <p>
	 * 
	 * @param operationVo
	 *            操作Vo对象
	 * @param positionId
	 * 			  职位id
	 */
	public void saveRejectToApply(OperationVo operationVo,String positionId);

	public void saveRead(OperationVo operationVo);

	/**
	 * 通过taskId获取流程实例id.
	 * <p>
	 * 
	 * @param taskId
	 *            任务ID
	 * @return
	 */
	public String getProcessInstanceId(String taskId);

	/**
	 * 查询是否存在可以驳回的节点.
	 * <p>
	 * 
	 * @param taskId
	 * @param processInstanceId
	 * @return
	 */
	public boolean hasRejectNodes(String taskId, String processInstanceId);

	/**
	 * 查询流程实例审批记录列表.
	 * <p>
	 * 
	 * @param processInstanceId
	 * @return
	 */
	public List<CommentVo> findActHiCommentEntity(String processInstanceId);
	
	/**
	 * 查询流程实例审批记录列表.
	 * <p>
	 * 
	 * @param businessKey 业务id
	 * @return
	 */
	public List<CommentVo> findActHiCommentByBusinessKey(String businessKey);
	
	/**
	 * 委派.
	 * <p>
	 * 
	 * @param myTaskVo
	 */
	public void reassign(MyTaskVo myTaskVo, String reassignComment, String reassignPositionCode);

	public void complete(String taskId, Map<String, Object> map);

	public void goProcessTaskNode(String taskId, String activityId, Map<String, Object> variables);
	/**
	 * 查询我的驳回任务列表.
	 * <p>
	 * 
	 * @param myTaskVo
	 * @param page
	 * @return
	 */
	public List<MyTaskVo> findMyRejectTaskList(MyTaskVo myTaskVo, Page page);

	/**
	 * 查找任务附件.
	 * <p>
	 * 
	 * @param taskId
	 * @return
	 */
	public List<TaAttachmentEntity> findAttachmentList(String taskId);

	/**
	 * 查找流程信息.
	 * <p>
	 * 
	 * @param myTaskVo request
	 * @return
	 */
	public void findProcessBasicInfoByProcinstId(MyTaskVo myTaskVo, HttpServletRequest request);

	/**
	 * 查找流程提交的附件.
	 * <p>
	 * 
	 * @param processInstanceId 流程实例ID
	 * @return
	 */
	public void findAttachmentListByProcinstId(String processInstanceId,HttpServletRequest request);

	/**
	 * 查找关键指标数据.
	 * <p>
	 * 
	 * @param 
	 * @return
	 */
	public void findKeyIndicators(MyTaskVo myTaskVo, HttpServletRequest request);

	/**
	 * 获取可以驳回的节点
	 * @param taskId
	 * @param processInstanceId
	 * @param request
	 */
	public void findRejectNode(String taskId, String processInstanceId, HttpServletRequest request);
	public List<Map<String, String>> findRejectNode(String taskId,String processInstanceId);
	/**
	 * 获取审批日志
	 * @param myTaskVo
	 * @param request
	 */
	public void findApprovalLogs(MyTaskVo myTaskVo, HttpServletRequest request);
	public List<TaProcessApprovalLogVo> findApprovalLogs(MyTaskVo myTaskVo);

	/**
	 * 获取可以驳回的节点
	 *
	 * @param processInstanceId
	 */
	public BusinessFormVo getBusinessFormByProcessInstanceId(String processInstanceId);

	/**
	 * 设置节点按钮权限
	 *
	 * @param myTaskVo
	 * @param request
	 */
	public void setNodeAuth(MyTaskVo myTaskVo, HttpServletRequest request);
}
