package com.biz.eisp.activiti.runtime.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.service.TaAttachmentService;
import com.biz.eisp.activiti.runtime.transformer.TaAttachmentEntityToTaAttachmentVo;
import com.biz.eisp.activiti.runtime.vo.TaAttachmentVo;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.google.common.collect.Lists;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
@Service("taAttachmentService")
@Transactional
public class TaAttachmentServiceImpl extends BaseServiceImpl implements TaAttachmentService{

	@Override
	public List<TaAttachmentVo> findAttachmentList(String taskId) {
		List<TaAttachmentEntity> entityList = this.findByProperty(TaAttachmentEntity.class, "taskId", taskId);
		List <TaAttachmentVo> voList = Lists.transform(entityList, new TaAttachmentEntityToTaAttachmentVo());
		return voList;
	}

}
