package com.biz.eisp.activiti.runtime.service.impl;

import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaBaseBusinessObjService;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;

/**
 * 基础业务对象CURD操作实现.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Service("taBaseBusinessObjService")
@Transactional
public class TaBaseBusinessObjServiceImpl extends BaseServiceImpl implements TaBaseBusinessObjService {

	@Autowired
	private HistoryService historyService;

	@Override
	public void updateBaseBusinessObjRuntimeStatus(String businessObjId, String runtimeStatusCode) {
		TaBaseBusinessObjQueryEntity entity = this.get(TaBaseBusinessObjQueryEntity.class, businessObjId);
		TaRuntimeStatusEntity statusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code",
				runtimeStatusCode);
		entity.setTaRuntimeStatusEntity(statusEntity);
		this.updateEntity(entity);
	}

	@Override
	public void updateBaseBusinessObjRuntimeStatusByProcessInstanceId(String processInstanceId,
			String runtimeStatusCode) {
		HistoricProcessInstance historicProcessInstance = historyService.createHistoricProcessInstanceQuery()
				.processInstanceId(processInstanceId).singleResult();
		String businessObjId = historicProcessInstance.getBusinessKey();
		this.updateBaseBusinessObjRuntimeStatus(businessObjId, runtimeStatusCode);
	}

}
