package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.runtime.dao.TaCarbonCopyDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaCarbonCopyEntity;
import com.biz.eisp.activiti.runtime.entity.TaCirculationContentEntity;
import com.biz.eisp.activiti.runtime.entity.TaCirculationEntity;
import com.biz.eisp.activiti.runtime.service.TaCarbonCopyService;
import com.biz.eisp.activiti.runtime.transformer.TaCarbonCopyEntityToTaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCarbonCopyVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyPersonInfoVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.google.common.collect.Lists;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 抄送功能service实现
 * @author wan
 * @version v1.0
 */
@Service("taCarbonCopyService")
@Transactional
public class TaCarbonCopyServiceImpl extends BaseServiceImpl implements TaCarbonCopyService{
	
	@Autowired
	private TaCarbonCopyDao taCarbonCopyDao;
	@Autowired
	private TaProcessService taProcessService;
	@Autowired(required = false)
	private RepositoryService repositoryService;
	@Autowired
	private TaskService taskService;
	@Autowired
	private RuntimeService runtimeService;
	@Autowired
	private HistoryService historyService;
	
	@Override
	public List<TaCarbonCopyVo> getAllByProcessKey(String taProcessKey) {
		String hql = "from TaCarbonCopyEntity t where t.taProcessKey = ?";
		List<TaCarbonCopyEntity> list = findByHql(hql,taProcessKey);
		return Lists.transform(list, new TaCarbonCopyEntityToTaCarbonCopyVo());
	}
	
	@Override
	public List<TaCopyCirculationVo> getCarbonCopyByConditions(TaCopyCirculationVo vo,Page page) {
		//设置查询条件
		TmPositionVo loginPosition = ResourceConfigUtils.getCurrPosition();
		//是抄送人的职位code,也是被传阅人code
		vo.setQueryCode(loginPosition.getPositionCode());
		String processInstanceId = vo.getProcessInstanceId();
		if(StringUtils.isNotBlank(processInstanceId)){
			vo.setProcessInstanceIdQuery(processInstanceId);
			vo.setProcessInstanceId(null);
		}
		List<TaCopyCirculationVo> list = taCarbonCopyDao.findCarbonCopyAndCirculation(vo, page);
		return list;
		
	}

	@Override
	public void saveCirculation(String processInstanceId,String codes,String names, String fullNames, String content) {
		//flag为false就是有不合法的
		boolean flag = this.validateValues(processInstanceId,codes,names);

		if(flag){
			//待传阅人编码
			String[] code = codes.split(",");
			//待传阅人名称
			String[] name = names.split(",");
			//待传阅人全名
			String[] fullName = fullNames.split(",");

			HistoricProcessInstance processInstance = historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
			String businessKey = processInstance.getBusinessKey();//拿到业务id

			ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery()
								.processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();

			//根据业务key查询业务信息
			TaBaseBusinessObjQueryEntity businessObjEntity = this.get(TaBaseBusinessObjQueryEntity.class, businessKey);
			TmPositionEntity tmPosition = businessObjEntity.getTmPositionEntity();//创建人的职位关系

			//保存传阅主表
			TaCirculationEntity circulation = new TaCirculationEntity();
			circulation.setBusinessKey(businessKey);
			circulation.setProcessInstanceId(processInstanceId);
			circulation.setProcessName(processDefinition.getName());
			circulation.setProcessKey(processDefinition.getKey());
			circulation.setProcessTitle(businessObjEntity.getProcessTitle());
			//传阅发起人职位编码
			circulation.setLaunchCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
			//传阅发起人职位名称
			circulation.setLaunchName(ResourceConfigUtils.getCreateName()); //存储人和职位信息
			//流程发起人职位编码
			circulation.setCreateProcessPositionCode(tmPosition.getPositionCode());
			//流程发起人职位名称
			circulation.setCreateProcessPositionName(tmPosition.getPositionName());
			super.save(circulation);

			for(int i = 0;i<code.length;i++){//保存内容
				TaCirculationContentEntity cirContent = new TaCirculationContentEntity();
				//主表Id
				cirContent.setTaCirculationId(circulation.getId());
				cirContent.setContent(content == null ? "传阅" : content);
				//被传阅人职位编码
				cirContent.setCirculationCode(code[i]);
				//被传阅人职位名称
				cirContent.setCirculationName(fullName[i] + "(" +name[i] + ")");
				//查阅状态：0没有阅读
				cirContent.setViewStatus("0");
				//是否阅读：0没有阅读，1已经阅读
				cirContent.setReadStatus("0");
				cirContent.setIsReply("0");
				this.save(cirContent);
			}

		}
	}

	@Override
	public void delCarbonCopyById(String ids){
		if(StringUtils.isNotBlank(ids)){
			String[] strs = ids.split(",");
			for(int i = 0;i<strs.length;i++){
				TaCarbonCopyEntity entity = this.get(TaCarbonCopyEntity.class, strs[i]);
				this.delete(entity);
			}
		}
	}

	@Override
	public AjaxJson saveCarbonCopy(TaCarbonCopyVo vo) {
		AjaxJson aj = new AjaxJson();
		
		//流程id
		String taProcessId = vo.getTaProcessId();
		//待抄送名称
		String code = vo.getCode();
		//待抄送名称
		String name = vo.getName();
		//标记按角色/职位抄送
		String state = vo.getState();
		//标识：按当前组织/当前组织及以下
		String chooseCondition = vo.getChooseCondition();

		if(StringUtils.isNotEmpty(taProcessId)&&StringUtils.isNotEmpty(state)){
			String[] codes = code.split(",");
			String[] names = name.split(",");
			for(int i = 0;i<codes.length;i++){
				//抄送编码
				String c = codes[i];
				//抄送名称
				String n = names[i];
				
				//校验需要抄送的数据是否重复，没有true,有false
				boolean flag = validateData(c, taProcessId);
				
				if(!flag){
					aj.setMsg("已经有重复的数据，不能再添加");
					aj.setSuccess(flag);
					return aj;
				}
				//得到流程设计主表实体
				TaProcessEntity processEntity = taProcessService.get(TaProcessEntity.class, taProcessId);
				
				//抄送配置表
				TaCarbonCopyEntity copyEntity = new TaCarbonCopyEntity();
				copyEntity.setTaProcessId(taProcessId);
				copyEntity.setTaProcessKey(processEntity.getProcessKey());
				copyEntity.setCode(c);// 角色/职位code
				copyEntity.setName(n);// 角色/职位name
				copyEntity.setState(state);//类型
				
				if(state.equals("0")){//角色
					copyEntity.setChooseCondition(chooseCondition);
				}else if(state.equals("1")){//职位
					copyEntity.setChooseCondition("0");//职位就是0
				}
				this.save(copyEntity);
			}
		}
		return aj;
	}

	@Override
	public List<TaCopyCirculationVo> findCopyAndCirculation(TaCopyCirculationVo vo,Page page) {
		TmPositionVo loginPosition = ResourceConfigUtils.getCurrPosition();
		if(StringUtils.isBlank(loginPosition.getPositionCode())){
			String sql = "select * from ta_copy t where t.id = '-1'";
			return this.findBySql(TaCopyCirculationVo.class,sql,page);
		}
		vo.setQueryCode(loginPosition.getPositionCode());//关于抄送给我的和传阅给我的
		List<TaCopyCirculationVo> result = taCarbonCopyDao.findCarbonCopyAndCirculationList(vo, page);
		return result;
	}
	
	
	@Override
	public List<TaCarbonCopyVo> findTaCarbonCopy(TaCarbonCopyVo vo,Page page) {
		Criterion cr1 = null;
		Criterion cr2 = null;
		Criterion cr3 = null;
		if(StringUtils.isNotEmpty(vo.getTaProcessId())){
			Criterion cr4 = Restrictions.eq("taProcessId", vo.getTaProcessId());
			if(null != vo.getCode() && !"".equals(vo.getCode())){
				cr1 = Restrictions.like("code", "%"+vo.getCode()+"%");
			}
			if(null != vo.getName() && !"".equals(vo.getName())){
				cr2 = Restrictions.like("name", "%"+vo.getName()+"%");
			}
			if(null != vo.getState() && !"".equals(vo.getState())){
				cr3 = Restrictions.eq("state", vo.getState());
			}
			List<TaCarbonCopyEntity> result = findByCriteria(TaCarbonCopyEntity.class, cr1,cr2,cr3,cr4);
			return Lists.transform(result, new TaCarbonCopyEntityToTaCarbonCopyVo());
		}else{
			throw new BusinessException("对不起，数据异常，联系管理员");
		}
	}
	
	
	/**
	 * 抄送：校验-新增的抄送，验证是否重复
	 * @author wan
	 * @param code
	 * @param taProcessId
	 * @return 
	 */
	private boolean validateData(String code,String taProcessId){
		String sql = "select * from ta_carboncopy t where t.ta_process_id = ? and t.code = ?";
		List<TaCarbonCopyEntity> list = findBySql(TaCarbonCopyEntity.class, sql, taProcessId,code);
		if(list.size() == 0){
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * 抄送：校验-私有方法，校验是否为
	 * @author wan
	 * @param strs
	 * @return
	 */
	private boolean validateValues(String... strs){
		for(int i = 0;i<strs.length;i++){
			if(StringUtils.isNotBlank(strs[i])){
				continue;
			}else{
				return false;
			}
		}
		return true;
	}

	private int getWordCountRegex(String s) {
		s = s.replaceAll("[^\\x00-\\xff]", "**");
		int length = s.length();
		return length;
	}

	@Override
	public List<TaCopyPersonInfoVo> findCopyPersonInfoList(TaCopyPersonInfoVo vo, Page page) {
		List <TaCopyPersonInfoVo> voList = taCarbonCopyDao.findCopyPersonInfoList(vo, page);
		return voList;
	}
}
