package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateEntity;
import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.activiti.runtime.service.TaCommunicateService;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * 沟通Service实现
 * Created by liukai on 2017/8/9.
 */
@Service("taCommunicateService")
@Transactional
public class TaCommunicateServiceImpl extends BaseServiceImpl implements TaCommunicateService {

    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;

    @Override
    public ValidForm saveCommunicate(String taskId, String codes, String names, String fullNames, String content, String forceReplyFlag) {
        ValidForm validForm = new ValidForm();
        validForm.setStatus("Y");
        validForm.setInfo("验证通过");
        //flag为false就是有不合法的
        boolean flag = this.validateValues(taskId, codes, names, content);

        if (flag) {
            //待传阅人编码
            String[] code = codes.split(",");
            //待传阅人名称
            String[] name = names.split(",");
            //待传阅人全名
            String[] fullName = fullNames.split(",");

            //根据任务id查询任务信息
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();

            //查询流程定义信息
            ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
            String piId = task.getProcessInstanceId();

            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
            String businessKey = processInstance.getBusinessKey();//拿到业务id

            //根据业务key查询业务信息
            TaBaseBusinessObjQueryEntity businessObjEntity = this.get(TaBaseBusinessObjQueryEntity.class, businessKey);
            TmPositionEntity tmPosition = businessObjEntity.getTmPositionEntity();//创建人的职位关系

            //保存传阅主表
            TaCommunicateEntity communicateEntity = new TaCommunicateEntity();
            communicateEntity.setBusinessKey(businessKey);
            communicateEntity.setProcessInstanceId(piId);
            communicateEntity.setProcessName(processDefinition.getName());
            communicateEntity.setProcessKey(processDefinition.getKey());
            communicateEntity.setProcessTitle(businessObjEntity.getProcessTitle());
            //沟通发起人职位编码
            communicateEntity.setLaunchCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
            //沟通发起人职位名称
            communicateEntity.setLaunchName(ResourceConfigUtils.getCreateName()); //存储人和职位信息
            //流程发起人职位编码
            communicateEntity.setCreateProcessPositionCode(tmPosition.getPositionCode());
            //流程发起人职位名称
            communicateEntity.setCreateProcessPositionName(tmPosition.getPositionName());
            communicateEntity.setProcessNodeKey(task.getTaskDefinitionKey());
//            communicateEntity.setProcessNodeName(task.gettas);
            communicateEntity.setTaskId(task.getId());
            communicateEntity.setTaskName(task.getName());

            super.save(communicateEntity);

            for (int i = 0; i < code.length; i++) {//保存内容
                TaCommunicateContentEntity communicateContentEntity = new TaCommunicateContentEntity();
                //主表Id
                communicateContentEntity.setTaCommunicateId(communicateEntity.getId());
                communicateContentEntity.setContent(content);
                //被传阅人职位编码
                communicateContentEntity.setCirculationCode(code[i]);
                //被传阅人职位名称
                communicateContentEntity.setCirculationName(fullName[i] + "(" + name[i] + ")");
                //查阅状态：0没有阅读
                communicateContentEntity.setViewStatus("0");
                //是否阅读：0没有阅读，1已经阅读
                communicateContentEntity.setReadStatus("0");
                communicateContentEntity.setIsReply("0");

                //如果是强制沟通，则设置强制沟通标记为Y
                if("Y".equals(forceReplyFlag)) {
                    communicateContentEntity.setForceReplyFlag("Y");
                } else {
                    communicateContentEntity.setForceReplyFlag("N");
                }

                this.save(communicateContentEntity);

                //保存日志记录信息
                saveApproveLog(piId, task.getTaskDefinitionKey(), content, name[i],fullName[i]);
            }
        } else {
            validForm.setStatus("N");
            validForm.setInfo("沟通数据验证不通过，请检查");
        }

        return validForm;
    }

    public ValidForm saveSureCommunicate(String communicateId, String content) {
        ValidForm validForm = new ValidForm();
        validForm.setStatus("Y");
        validForm.setInfo("验证通过");
        TaCommunicateContentEntity communicateContentEntity = this.get(TaCommunicateContentEntity.class, communicateId);
        communicateContentEntity.setIsReply("1");
        communicateContentEntity.setReciveContent(content);
        communicateContentEntity.setForceReplyFlag("N"); //修改强制沟通标识为N
        this.updateEntity(communicateContentEntity);
        TaCommunicateEntity communicateEntity = this.get(TaCommunicateEntity.class, communicateContentEntity.getTaCommunicateId());
        saveReplyApproveLog(communicateEntity.getProcessInstanceId(),
                communicateEntity.getProcessNodeKey(), content);
        return validForm;
    }

    private void saveApproveLog(String processInstanceId, String taskDefinitionKey, String content,
                                String positionName, String fullName) {
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        TmUserVo user = ResourceConfigUtils.getSessionTmUserVo();

        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent("【" + positionName + " " + fullName + "】" + content);
        log.setName(user.getFullName());
        log.setProcessInstId(processInstanceId);
        try {
            log.setTaskDefKey(taskDefinitionKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(3);
        this.save(log);
    }

    private void saveReplyApproveLog(String processInstanceId, String taskDefinitionKey, String content) {
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        TmUserVo user = ResourceConfigUtils.getSessionTmUserVo();

        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent(content);
        log.setName(user.getFullName());
        log.setProcessInstId(processInstanceId);
        try {
            log.setTaskDefKey(taskDefinitionKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(3);
        this.save(log);
    }

    /**
     * 抄送：校验-私有方法，校验是否为
     *
     * @param strs
     * @return
     * @author wan
     */
    private boolean validateValues(String... strs) {
        for (int i = 0; i < strs.length; i++) {
            if (StringUtils.isNotBlank(strs[i])) {
                continue;
            } else {
                return false;
            }
        }
        return true;
    }
}
