package com.biz.eisp.activiti.runtime.service.impl;

import java.util.*;

import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaRRoleProcDefEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.activiti.runtime.dao.TaDeploymentDao;
import com.biz.eisp.activiti.runtime.service.TaDeploymentService;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.StreamUtils;

/**
 * 部署管理Service实现.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Service("taDeploymentService")
@Transactional
public class TaDeploymentServiceImpl extends BaseServiceImpl implements TaDeploymentService {

	@Autowired(required = false)
	private RepositoryService repositoryService;
	@Autowired
	private TaDeploymentDao taDeploymentDao;

	@Override
	public void deployProcess(String processId) {
		TaProcessEntity process = this.get(TaProcessEntity.class, processId);
		if (process != null) {
			Deployment deployment = this.deploy(process);
			
			//保存角色与流程关系
			this.saveTaRRoleProcDef(deployment);
			
			//修改流程设计为已发布状态
			process.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_YES);
			this.updateEntity(process);
		} else {
			throw new BusinessException("为找到流程设计ID");
		}
	}

	
	public Deployment deploy(TaProcessEntity process) {
		Deployment deployment = null;
		try {
			deployment = repositoryService.createDeployment().addInputStream(process.getProcessKey()
					+ ".bpmn", StreamUtils.byteTOInputStream(process.getProcessXml()))
					.name(process.getProcessKey()).deploy();
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		return deployment;
	}
	
	public void saveTaRRoleProcDef(Deployment deployment) {
		ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery()
				.deploymentId(deployment.getId()).singleResult();

		ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
				.getDeployedProcessDefinition(processDefinition.getId());
		Map<String, TaskDefinition> taskDefinitionMap = processDefinitionEntity.getTaskDefinitions();
		 Set <String>taskKeySet = taskDefinitionMap.keySet();
		 
		 for(Iterator<String> iter = taskKeySet.iterator(); iter.hasNext();) {
			 String key = iter.next();
			 TaskDefinition td = taskDefinitionMap.get(key);
			 Set <Expression> candidateGroupIdSet = td.getCandidateGroupIdExpressions();
			 
			 for(Iterator <Expression> iter2 = candidateGroupIdSet.iterator(); iter2.hasNext();) {
				 Expression expression = iter2.next();
				 String value = expression.getExpressionText();
				 
				 TaRRoleProcDefEntity taRRoleProcDefEntity = this.getTaRRoleProcDefEntity(deployment.getId(), value);
				 if(taRRoleProcDefEntity == null) {
					 taRRoleProcDefEntity = new TaRRoleProcDefEntity();
					 taRRoleProcDefEntity.setDeploymentId(deployment.getId());
					 taRRoleProcDefEntity.setRoleCode(value);
					 this.save(taRRoleProcDefEntity);
				 }
			 }
		 }
		//生成扩展表版本数据
		List<String> list=new ArrayList<>();
		list.add(processDefinition.getId());
		list.add(processDefinition.getKey());
		//执行过程备份数据
		int s=this.callableStatementByName("PT_ACT_PROCESS_PRO",list);
		if (s<=0){
			throw new BusinessException("版本灵气复制失败！");
		}
	}
	
	private TaRRoleProcDefEntity getTaRRoleProcDefEntity(String deploymentId, String roleCode) {
		String hql = "from TaRRoleProcDefEntity t where t.deploymentId = ? and t.roleCode = ?";
		List <TaRRoleProcDefEntity>list = this.findByHql(hql, deploymentId, roleCode);
		if(list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}


	@Override
	public List<TaProcessVo> findTaProcessVoList(TaProcessVo taProcessVo, String roleCode, Page page) {
		List<TaProcessVo> list = taDeploymentDao.findTaProcessVoList(taProcessVo, roleCode, page);
		return list;
	}
		
}
