package com.biz.eisp.activiti.runtime.service.impl;

import java.util.List;


import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.runtime.dao.TaCarbonCopyDao;
import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.entity.TaCirculationContentEntity;
import com.biz.eisp.activiti.runtime.service.TaHandCopyAndCirculationService;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;

/** 
 * 操作抄送和传阅的处理
 * @author wan
 * @version v1.0
 */
@Service("taHandCopyAndCirculationService")
@Transactional
public class TaHandCopyAndCirculationServiceImpl extends BaseServiceImpl implements TaHandCopyAndCirculationService{
	@Autowired
	private TaTaskDao taTaskDao;
	@Autowired
	private TaCarbonCopyDao taCarbonCopyDao;
	
	
	@Override
	public String getCopyAndCirculationBusinessForm(String piId,String businessKey) {
		BusinessFormVo vo = taTaskDao.getBusinessFormByProcessInstanceId(piId);
		try {
			String view = vo.getModelandview();
			String objId = vo.getBusinessObjId();
			String modelandview = view + "&businessObjId=" + objId;
			return modelandview;
		} catch (Exception e) {
			return null;
		}
	}
	
	@Override
	public void updateCarbonOrCirculationState(TaCopyCirculationVo vo) {
		String sql = null;
		if("0".equals(vo.getType())){//抄送
			sql = "update ta_copy t set t.view_status = 1 where id = ?";
			executeSql(sql, vo.getContentId());
		}else if("1".equals(vo.getType())){
			String positionCode = ResourceConfigUtils.getCurrPosition().getPositionCode();
			if("1".equals(vo.getInOutType())){//传出
				sql = "update ta_circulation_content t set t.read_status = '0' where id = ?";
				executeSql(sql,vo.getContentId());
			}else if("0".equals(vo.getInOutType())){//传进
				sql = "update ta_circulation_content t set t.view_status = '1' where id = ? and circulation_code = ?";
				executeSql(sql,vo.getContentId(),positionCode);
			}
		}else{
			throw new BusinessException("对不起，你查阅的数据有误");
		}
	}

	@Override
	public void saveCirculationContent(String id, String content) {
		String hql = "from TaCirculationContentEntity where taCirculationId = ? and circulationCode = ?";
		List<TaCirculationContentEntity> list = this.findByHql(hql, id, ResourceConfigUtils.getCurrPosition().getPositionCode());
		try {
			for(TaCirculationContentEntity entity : list){
				entity.setReciveContent(content);
				entity.setReadStatus("1");
				entity.setIsReply("1");
				entity.setViewStatus("1");
				saveOrUpdate(entity);
			}
		}catch(Exception e){
			throw new BusinessException("你已超过最大限制字数,最大字数:250");
		}

	}

	@Override
	public List<TaCopyCirculationVo> findCirculationMessage(TaCopyCirculationVo query) {
		List<TaCopyCirculationVo> result = taCarbonCopyDao.findCirculationById(query);
		return result;
	}
}
