package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.model.diagram.HistoryProcessInstanceDiagramCmd;
import com.biz.eisp.activiti.model.diagram.HistoryProcessInstanceDiagramPositionCmd;
import com.biz.eisp.activiti.runtime.dao.TaProcessInstanceDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.transformer.HistoricTaskInstanceToHistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.biz.eisp.activiti.runtime.vo.ProcessInstanceVo;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import com.google.common.collect.Lists;
import org.activiti.engine.*;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 流程实例管理Service实现.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Service("taProcessInstanceService")
@Transactional
public class TaProcessInstanceServiceImpl extends BaseServiceImpl implements TaProcessInstanceService {

	@Autowired
	private IdentityService identityService;
	@Autowired
	private RuntimeService runtimeService;
	@Autowired
	private HistoryService historyService;
	@Autowired(required = false)
	private RepositoryService repositoryService;
	@Autowired
	private TaskService taskService;
	@Autowired
	private TaProcessInstanceDao taProcessInstanceDao;
	@Autowired
	private TmUserService tmUserService;

	/**
	 * 根据职位获取用户信息.
	 * @author grover
	 * @param posId
	 * 		职位id
	 * @return
	 */
	@SuppressWarnings("deprecation")
	private UserInfoEntity findUserInfo(String posId) {
		UserInfoEntity userInfoEntity = tmUserService.findUserInfoEntityByPosId(posId);
		return userInfoEntity;
	}
	/**
	 * 获取用户名字+职位名称.
	 * @author grover
	 * @param posId
	 * 		职位id
	 * @return
	 */
	@SuppressWarnings("deprecation")
	private String getCreateName(String posId) {
		//session 取不到时重现查询取值
		if(StringUtil.isNotEmpty(ResourceConfigUtils.getCreateName())){
			return ResourceConfigUtils.getCreateName();
		}else{
			UserInfoEntity userInfoEntity = findUserInfo(posId);
			if(StringUtil.isNotEmpty(userInfoEntity)){
				return userInfoEntity.getRealName() + "("+userInfoEntity.getPosName()+")";
			}
		}
		return "";
	}
	
	@Override
	public void saveStartWorkflow(String processKey, String positionCode, String businessKey,
			Map<String, Object> variables) {
		//启动流程
		identityService.setAuthenticatedUserId(positionCode);// 设置流程发起人
		
		ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(processKey, businessKey,
				variables);
		
		//添加发起流程处理信息
		taskService.addComment(null, processInstance.getId(),
				CommentUtil.buildApplyComment(ResourceConfigUtils.getCreateName()));
		//加入日志
		TmUserEntity user = ResourceConfigUtils.getClient().getUser();
		TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
		log.setCreateDate(new Date());
		log.setAccount(user.getUserName());
		log.setContent("发起流程");
		log.setName(user.getFullName());
		log.setProcessInstId(processInstance.getId());
		log.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		log.setPositionName(ResourceConfigUtils.getCurrPosition().getPositionName());
		try {
			log.setTaskDefKey(null);
		} catch (Exception e) {
			e.printStackTrace();
		}
		log.setType(1);
		this.save(log);
		
		TaBaseBusinessObjEntity taBaseBusinessObjEntity = this.get(TaBaseBusinessObjEntity.class, businessKey);
		TaRuntimeStatusEntity runStatus = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code","doing");
		taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runStatus);
		this.saveOrUpdate(taBaseBusinessObjEntity);
	}
	
	@Override
	public void saveStartWorkflow(TaProcessBusinessObjConfigVo configVo, TaBaseBusinessObjEntity baseEntity) {
		//业务配置实体
		TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity = this.get(TaProcessBusinessObjConfigEntity.class, configVo.getId());

		if (taProcessBusinessObjConfigEntity != null) {
			// 获取业务实体父类对象
			TaBaseBusinessObjEntity taBaseBusinessObjEntity = baseEntity;
			// 获取状态
			TaRuntimeStatusEntity runtimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code","new");
			TaRuntimeStatusEntity rejectRuntimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code","reject");
			//当在保存流程的时候，会自动将改流程状态设置为new
			TaRuntimeStatusEntity businessObjRuntimeStatus = taBaseBusinessObjEntity.getTaRuntimeStatusEntity();
			//如果当前需要启动的流程是：驳回状态或者追回状态
			if(businessObjRuntimeStatus.getCode().equals(rejectRuntimeStatusEntity.getCode())){
				//变量
				Map<String, Object> variables = configVo.getVariables();
				//启动流程
				this.saveStartWorkflow(taBaseBusinessObjEntity,variables, taProcessBusinessObjConfigEntity);
				
				//任务状态：处理中
				TaRuntimeStatusEntity runStatus = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code","doing");
				////将改流程的状态设置为doing
				taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runStatus);
				
				this.saveOrUpdate(taBaseBusinessObjEntity);
				
			} else if (businessObjRuntimeStatus.getCode().equals(runtimeStatusEntity.getCode())){//新建
				//需要启动时，带的变量
				Map<String, Object> variables = configVo.getVariables();
				//启动流程
				this.saveStartWorkflow(taBaseBusinessObjEntity,variables, taProcessBusinessObjConfigEntity);
				
				//任务状态：处理中
				TaRuntimeStatusEntity runStatus = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code","doing");
				////将流程设置为：处理中
				taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runStatus);
				
				this.saveOrUpdate(taBaseBusinessObjEntity);
			} else {
				throw new BusinessException("已经在流程办理中");
			}
		}
	}
	@SuppressWarnings("deprecation")
	@Override
	public ProcessInstance saveStartWorkflow(TaBaseBusinessObjEntity baseEntity, Map<String, Object> variables,
			TaProcessBusinessObjConfigEntity configEntity) {
		TmPositionEntity tmPositionEntity = baseEntity.getTmPositionEntity();// 获取创建职位
		identityService.setAuthenticatedUserId(tmPositionEntity.getPositionCode());// 设置流程发起人
		String processKey = configEntity.getTaProcessEntity().getProcessKey();
		ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(processKey, baseEntity.getId(),variables);
		//添加发起流程处理信息
//		String createName = getCreateName(tmPositionEntity.getId());
//		taskService.addComment(null, processInstance.getId(),CommentUtil.buildApplyComment(createName));
		//加入日志
		Client client = ResourceConfigUtils.getClient();
		TmUserEntity user = null;
		if(StringUtil.isEmpty(client)){
			UserInfoEntity userInfoEntity = findUserInfo(tmPositionEntity.getId());
			user = new TmUserEntity();
			user.setUserName(userInfoEntity.getUserName());
			user.setFullName(userInfoEntity.getRealName());
		}else{
			user = client.getUser();
		}
		TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
		log.setCreateDate(new Date());
		log.setAccount(user.getUserName());
		log.setContent("发起流程");
		log.setName(user.getFullName());
		log.setProcessInstId(processInstance.getId());
		log.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		log.setPositionName(ResourceConfigUtils.getCurrPosition().getPositionName());
		try {
			log.setTaskDefKey(null);
		} catch (Exception e) {
			e.printStackTrace();
		}
		log.setType(1);
		this.save(log);
		return processInstance;
	}
	
	@Override
	public ProcessInstance saveStartWorkflow(TaBaseBusinessObjQueryEntity taBaseBusinessObjEntity, String businessObjId,
			Map<String, Object> variables, TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity) {

		TmPositionEntity tmPositionEntity = taBaseBusinessObjEntity.getTmPositionEntity();// 获取创建职位

		identityService.setAuthenticatedUserId(tmPositionEntity.getPositionCode());// 设置流程发起人

		String processKey = taProcessBusinessObjConfigEntity.getTaProcessEntity().getProcessKey();

		ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(processKey, businessObjId,
				variables);
		//添加发起流程处理信息
		taskService.addComment(null, processInstance.getId(),
				CommentUtil.buildApplyComment(ResourceConfigUtils.getCreateName()));

		//加入日志
		TmUserEntity user = ResourceConfigUtils.getClient().getUser();
		TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
		log.setCreateDate(new Date());
		log.setAccount(user.getUserName());
		log.setContent("发起流程");
		log.setName(user.getFullName());
		log.setProcessInstId(processInstance.getId());
		log.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		log.setPositionName(ResourceConfigUtils.getCurrPosition().getPositionName());
		try {
			log.setTaskDefKey(null);
		} catch (Exception e) {
			e.printStackTrace();
		}
		log.setType(1);
		this.save(log);
		
		return processInstance;
	}

	@Override
	public void saveStartWorkflow(TaProcessBusinessObjConfigVo taProcessBusinessObjConfigVo) {
		TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity = this
				.get(TaProcessBusinessObjConfigEntity.class, taProcessBusinessObjConfigVo.getId());

		if (taProcessBusinessObjConfigEntity != null) {
			// 获取业务实体父类对象
			TaBaseBusinessObjQueryEntity taBaseBusinessObjEntity = this.get(TaBaseBusinessObjQueryEntity.class,taProcessBusinessObjConfigVo.getBusinessObjId());

			// 获取状态
			TaRuntimeStatusEntity runtimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code",
					"new");
			TaRuntimeStatusEntity rejectRuntimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code",
					"reject");
			TaRuntimeStatusEntity recoverRuntimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code",
					"recover");
			
			TaRuntimeStatusEntity businessObjRuntimeStatus = taBaseBusinessObjEntity.getTaRuntimeStatusEntity();

			if(businessObjRuntimeStatus.getCode().equals(rejectRuntimeStatusEntity.getCode())
					|| businessObjRuntimeStatus.getCode().equals(recoverRuntimeStatusEntity.getCode())) {
				//激活流程
				//加入备注
//				ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(taProcessBusinessObjConfigVo.getBusinessObjId(),
//						taProcessBusinessObjConfigEntity.getTaProcessEntity().getProcessKey()).singleResult();
//				runtimeService.activateProcessInstanceById(processInstance.getId());
//				//添加发起流程处理信息
//				taskService.addComment(null, processInstance.getId(),
//						CommentUtil.buildApplyComment(ResourceUtil.getCreateName()));
//				TaRuntimeStatusEntity runtimeStatusEntity1 = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code",
//						"doing");
//				
//				taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runtimeStatusEntity1);
//
//				this.saveOrUpdate(taBaseBusinessObjEntity);
				Map<String, Object> variables = taProcessBusinessObjConfigVo.getVariables();
				
				this.saveStartWorkflow(taBaseBusinessObjEntity, taProcessBusinessObjConfigVo.getBusinessObjId(),
						variables, taProcessBusinessObjConfigEntity);

				TaRuntimeStatusEntity runtimeStatusEntity1 = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code",
						"doing");
				
				taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runtimeStatusEntity1);

				this.saveOrUpdate(taBaseBusinessObjEntity);
			} else if (businessObjRuntimeStatus.getCode().equals(runtimeStatusEntity.getCode())) {
				Map<String, Object> variables = taProcessBusinessObjConfigVo.getVariables();

				this.saveStartWorkflow(taBaseBusinessObjEntity, taProcessBusinessObjConfigVo.getBusinessObjId(),
						variables, taProcessBusinessObjConfigEntity);

				TaRuntimeStatusEntity runtimeStatusEntity1 = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code",
						"doing");
				
				taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runtimeStatusEntity1);

				this.saveOrUpdate(taBaseBusinessObjEntity);

			} else {
				throw new BusinessException("已经在流程办理中");
			}
		}
	}

	@Override
	public List<MyInstanceVo> findMyStartedProcessList(MyInstanceVo myInstanceVo, Page page) {
		List<MyInstanceVo> myInstanceVoList = taProcessInstanceDao.findMyStartedProcessList(myInstanceVo, page);
		this.calSpendTimes(myInstanceVoList);
		return myInstanceVoList;
	}

	/**
	 * 计算耗时.
	 * <p>
	 * 
	 * @param myInstanceVoList
	 */
	private void calSpendTimes(List<MyInstanceVo> myInstanceVoList) {
		if (myInstanceVoList != null) {
			for (MyInstanceVo vo : myInstanceVoList) {
				vo.setSpendTimes(DateUtils.calSpendTimes(vo.getStartTime(), vo.getEndTime()));
			}
		}
	}
	
	@Override
	public List<ProcessInstanceVo> findProcessInstanceList(ProcessInstanceVo processInstanceVo, Page page) {
		List<ProcessInstanceVo> processInstanceVoList = taProcessInstanceDao.findProcessInstanceList(processInstanceVo, page);
		this.calProcessInstanceSpendTimes(processInstanceVoList);
		return processInstanceVoList;
	}
	
	/**
	 * 计算耗时.
	 * <p>
	 * 
	 * @param processInstanceVoList
	 */
	private void calProcessInstanceSpendTimes(List<ProcessInstanceVo> processInstanceVoList) {
		if (processInstanceVoList != null) {
			for (ProcessInstanceVo vo : processInstanceVoList) {
				vo.setSpendTimes(DateUtils.calSpendTimes(vo.getStartTime(), vo.getEndTime()));
			}
		}
	}

	@Override
	public InputStream getProcessInstancePicInfo(String processInstanceId) {
		Command<InputStream> cmd = new HistoryProcessInstanceDiagramCmd(processInstanceId);
		ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
		InputStream is = processEngine.getManagementService().executeCommand(cmd);
		return is;
	}

	@Override
	public String getProcessInstanceIdByTaskId(String taskId) {
		Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
		return task.getProcessInstanceId();
	}

	public List<String> highLight(String processInstanceId) {
		List<String> highLihth = new ArrayList<String>();
		List<Execution> executions = runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
		for (Execution execution : executions) {
			ExecutionEntity entity = (ExecutionEntity) runtimeService.createExecutionQuery()
					.executionId(execution.getId()).singleResult();
			highLihth.add(entity.getActivityId());
		}
		return highLihth;
	}

	@Override
	public List<HistoryTaskVo> findProcessInstanceHistoryTaskList(HistoryTaskVo historyTaskVo, Page page) {
		String processInstanceId = historyTaskVo.getProcessInstanceId();

		if (StringUtils.isBlank(processInstanceId)) {
			throw new BusinessException("流程实例ID（processInstanceId）为空");
		}

		// 获取流程实例的历史任务列表
		List<HistoricTaskInstance> historicTaskInstanceList = historyService.createHistoricTaskInstanceQuery()
				.processInstanceId(processInstanceId).list();

		// 转换entity为Vo
		List<HistoryTaskVo> voList = Lists.transform(historicTaskInstanceList,
				new HistoricTaskInstanceToHistoryTaskVo());

		return voList;
	}

	@Override
	public List<ActivityImpl> findDiagramPositionList(String processInstanceId) {
		Command cmd = new HistoryProcessInstanceDiagramPositionCmd(processInstanceId);

		ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();

		List<ActivityImpl> list = (List<ActivityImpl>) processEngine.getManagementService().executeCommand(cmd);

		return list;
	}

	@Override
	public void deleteProcessInstance(MyInstanceVo myInstanceVo) {
		String createName = ResourceConfigUtils.getCreateName();
		runtimeService.deleteProcessInstance(myInstanceVo.getProcessInstanceId(), "发起人" + createName + "删除流程实例");
	}

	@Override
	public void suspendProcessInstance(MyInstanceVo myInstanceVo) {
		runtimeService.suspendProcessInstanceById(myInstanceVo.getProcessInstanceId());
	}

	@Override
	public void activateProcessInstance(MyInstanceVo myInstanceVo) {
		runtimeService.activateProcessInstanceById(myInstanceVo.getProcessInstanceId());
	}

	@Override
	public void callBackProcess(MyInstanceVo myInstanceVo) {
		String createName = ResourceConfigUtils.getCreateName();
		
		ProcessInstance pi = runtimeService.createProcessInstanceQuery().processInstanceId(myInstanceVo.getProcessInstanceId()).singleResult();
		List <Execution> executionList = runtimeService.createExecutionQuery().processInstanceId(myInstanceVo.getProcessInstanceId()).list();
		
		
		String businessObjId = pi.getBusinessKey();
		
		TaBaseBusinessObjQueryEntity entity = this.get(TaBaseBusinessObjQueryEntity.class, businessObjId);
		
		String runtimeStatus = entity.getTaRuntimeStatusEntity().getCode();
		
		if(runtimeStatus.equals("completed")) {
			throw new BusinessException("流程已完成不能追回");
		}
		if(runtimeStatus.equals("reject")) {
			throw new BusinessException("流程已驳回不能追回");
		}
		
		taskService.addComment(null, pi.getProcessInstanceId(), CommentUtil.buildRecoverComment(ResourceConfigUtils.getCreateName(), "追回流程"));
		
		//修改状态
		TaRuntimeStatusEntity recoverStatas = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "recover");
		entity.setTaRuntimeStatusEntity(recoverStatas);
		this.updateEntity(entity);

		if(CollectionUtil.listNotEmptyNotSizeZero(executionList)) {
			for(Execution execution : executionList) {
				runtimeService.setVariable(execution.getId(), "aborts", WorkFlowGlobals.BPM_BUS_STATUS_5);
			}
		}
		
		runtimeService.deleteProcessInstance(myInstanceVo.getProcessInstanceId(), "recover");
		
	}

	@Override
	public void closeProcessInstance(MyInstanceVo myInstanceVo) {
		String createName = ResourceConfigUtils.getCreateName();
		taskService.addComment(null, myInstanceVo.getProcessInstanceId(), CommentUtil.buildCloseComment(ResourceConfigUtils.getCreateName(), "关闭流程"));
		runtimeService.deleteProcessInstance(myInstanceVo.getProcessInstanceId(), createName + "关闭流程实例");
	}
	
}
