package com.biz.eisp.activiti.runtime.service.impl;

import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import com.biz.eisp.activiti.common.TaProcessThemeCommand;
import com.biz.eisp.activiti.common.TaProcessThemeReceiver;
import com.biz.eisp.activiti.common.impl.TaProcessThemeCommandImpl;
import com.biz.eisp.activiti.common.impl.TaProcessThemeExecutorImpl;
import com.biz.eisp.activiti.runtime.service.TaProcessThemeService;
import com.biz.eisp.activiti.runtime.vo.TaProcessThemeVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.utils.ApplicationContextUtils;

@Service("taProcessThemeService")
public class TaProcessThemeServiceImpl implements TaProcessThemeService   {

	/**
	 * 流程主题-执行提交方法。接口留给业务实现service
	 */
	@Override
	public AjaxJson doSubmit(HttpServletRequest request) throws Exception {
		AjaxJson returnJson = new AjaxJson();
		//name 主题名
		String name = request.getParameter("name");
		//主题详情
		String detail = request.getParameter("detail");
		//businessKey
		String businessKey = request.getParameter("businessKey");
		//businessKeyMain
		String businessKeyMain = request.getParameter("businessKeyMain");
		//调用业务service (全类名)
		String fullPathName = request.getParameter("fullPathName");
		//其他参数{json字符串}
		String params = request.getParameter("params");
		
		//设置传递的参数 vo
		TaProcessThemeVo vo = new TaProcessThemeVo();
		vo.setBusinessKey(businessKey);
		vo.setDetail(detail.replace("\n","</br>"));
		vo.setName(name);
		vo.setBusinessKeyMain(businessKeyMain);
		vo.setParams(params);
			
		//获取接收者的全类名
		Class<?> businessClass = Class.forName(fullPathName);
		//获取接收者 即业务真正的提交controller类
		TaProcessThemeReceiver receiver = (TaProcessThemeReceiver) ApplicationContextUtils.getContext().getBean(businessClass);
			
		//设置命令
		TaProcessThemeCommand command = new TaProcessThemeCommandImpl(receiver, vo);
		TaProcessThemeExecutorImpl excutor = new TaProcessThemeExecutorImpl(); 
		excutor.setCommand(command);
			
		//执行命令
		excutor.execute();
		//返回结果
		returnJson = excutor.getJson();
		return returnJson;
	}
}
