package com.biz.eisp.activiti.runtime.service.impl;

import java.util.List;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.runtime.dao.TaRejectRecordDao;
import com.biz.eisp.activiti.runtime.entity.TaRejectRecordEntity;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.transformer.TaRejectRecordVoToTaRejectRecordEntity;
import com.biz.eisp.activiti.runtime.vo.TaRejectRecordVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;

/** 驳回数据记录CURD 实现.
 * <p>
 * @author liukai
 * @version v1.0
 */
@Service("taRejectRecordService")
@Transactional
public class TaRejectRecordServiceImpl extends BaseServiceImpl implements TaRejectRecordService{

	@Autowired
	private TaRejectRecordDao taRejectRecordDao;
	@Autowired
	private TmUserService tmUserService;
	
	@Override
	public void saveTaRejectRecord(String processInstanceId) {
		List<TaRejectRecordVo> taRejectRecordVoList = taRejectRecordDao.getTaRejectRecordVo(processInstanceId);
		TaRejectRecordVo taRejectRecordVo = taRejectRecordVoList.get(0);
		taRejectRecordVo.setRejectPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		taRejectRecordVo.setRejectPositionName(ResourceConfigUtils.getCurrPosition().getPositionName());
		taRejectRecordVo.setRejectUserName(ResourceConfigUtils.getSessionTmUserVo().getFullName());
		taRejectRecordVo.setReadStatus(0);
		TaRejectRecordEntity entity = new TaRejectRecordVoToTaRejectRecordEntity(this).apply(taRejectRecordVo);
		this.saveOrUpdate(entity);
	}
	@Override
	public void saveTaRejectRecord(String processInstanceId,String positionId) {
		UserInfoEntity userInfoEntity = tmUserService.findUserInfoEntityByPosId(positionId);
		List<TaRejectRecordVo> taRejectRecordVoList = taRejectRecordDao.getTaRejectRecordVo(processInstanceId);
		TaRejectRecordVo taRejectRecordVo = taRejectRecordVoList.get(0);
		taRejectRecordVo.setRejectPositionCode(userInfoEntity.getPosCode());
		taRejectRecordVo.setRejectPositionName(userInfoEntity.getPosName());
		taRejectRecordVo.setRejectUserName(userInfoEntity.getRealName());
		taRejectRecordVo.setReadStatus(0);
		TaRejectRecordEntity entity = new TaRejectRecordVoToTaRejectRecordEntity(this).apply(taRejectRecordVo);
		this.saveOrUpdate(entity);
	}

	@Override
	public List<TaRejectRecordVo> findMyRejectTaskList(TaRejectRecordVo taRejectRecordVo, Page page) {
		List <TaRejectRecordVo> voList = taRejectRecordDao.findMyRejectTaskList(taRejectRecordVo, page);
		return voList;
	}

	@Override
	public void updateTaRejectRecordStatus(String id) {
		TaRejectRecordEntity entity = this.get(TaRejectRecordEntity.class, id);
		entity.setReadStatus(1);
		this.updateEntity(entity);
	}
	
}
