package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeAuthVo;
import com.biz.eisp.activiti.entity.TaRejectReadEntity;
import com.biz.eisp.activiti.entity.activiti.ActHiProcinstEntity;
import com.biz.eisp.activiti.entity.activiti.ActReProcdefEntity;
import com.biz.eisp.activiti.entity.activiti.ActRuTaskEntity;
import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.entity.*;
import com.biz.eisp.activiti.runtime.service.*;
import com.biz.eisp.activiti.runtime.transformer.HistoricTaskInstanceToHistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.*;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.*;
import com.biz.eisp.base.core.entity.TbAttachmentQueryEntity;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;
import com.google.common.collect.Lists;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.*;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.*;

/**
 * 任务管理Service实现.
 * <p>
 *
 * @author liukai
 * @version v1.0
 */
@Service("taTaskService")
@Transactional
public class TaTaskServiceImpl extends BaseServiceImpl implements TaTaskService {

    @Autowired(required = false)
    private TaApprovalLogExtendService taApprovalLogExtendService;

	@Autowired
	private TaskService taskService;

	@Autowired
	private TmUserService tmUserService;

	@Autowired
	private RuntimeService runtimeService;

	@Autowired
	private HistoryService historyService;

	@Autowired(required = false)
	private RepositoryService repositoryService;

	@Autowired
	private TaProcessNodeService taProcessNodeService;

	@Autowired
	private TaBaseBusinessObjService taBaseBusinessObjService;

	@Autowired
	private TaTaskDao taTaskDao;

	@Autowired
	private TaRejectRecordService taRejectRecordService;

	@Autowired
	private TaAttachmentService taAttachmentService;
	@Autowired
	private TmActRoleService tmActRoleService;

	@Override
	public List<MyTaskVo> findMyTaskList(MyTaskVo myTaskVo, Page page) {
		List<MyTaskVo> myTaskVoList = taTaskDao.findMyTaskList(myTaskVo, page);
		return myTaskVoList;
	}
    @Override
	public String getBusinessObjIdByTask(Task task) {
		String businessKey = "";
		// TaskEntity taskEntity = (TaskEntity)
		// taskService.createTaskQuery().taskId(task.getId()).singleResult();//(TaskEntity)
		// taskService.createTaskQuery().taskId(task.getId()).singleResult();
		HistoricProcessInstance hiproins = historyService.createHistoricProcessInstanceQuery()
				.processInstanceId(this.getProcessInstanceId(task.getId())).singleResult();

		if (hiproins != null) {
			if (hiproins.getSuperProcessInstanceId() != null && hiproins.getBusinessKey() == null) {
				hiproins = historyService.createHistoricProcessInstanceQuery()
						.processInstanceId(hiproins.getSuperProcessInstanceId()).singleResult();
				businessKey = hiproins.getBusinessKey();
			} else {
				businessKey = hiproins.getBusinessKey();
			}
		}

		return businessKey;
	}

	public String getBusinessObjIdByTaskId(String taskId) {
		String businessKey = "";
		// TaskEntity taskEntity = (TaskEntity)
		// taskService.createTaskQuery().taskId(task.getId()).singleResult();//(TaskEntity)
		// taskService.createTaskQuery().taskId(task.getId()).singleResult();
		HistoricProcessInstance hiproins = historyService.createHistoricProcessInstanceQuery()
				.processInstanceId(this.getProcessInstanceId(taskId)).singleResult();

		if (hiproins != null) {
			if (hiproins.getSuperProcessInstanceId() != null && hiproins.getBusinessKey() == null) {
				hiproins = historyService.createHistoricProcessInstanceQuery()
						.processInstanceId(hiproins.getSuperProcessInstanceId()).singleResult();
				businessKey = hiproins.getBusinessKey();
			} else {
				businessKey = hiproins.getBusinessKey();
			}
		}

		return businessKey;
	}

	/**
	 * 获取流程定义对象.
	 * <p>
	 *
	 * @param processDefinitionId
	 *            流程定义id
	 * @return
	 */
	public ProcessDefinition getProcessDefinition(String processDefinitionId) {
		return repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
	}

	public Task getTask(String taskId) {
		return taskService.createTaskQuery().taskId(taskId).singleResult();
	}

	public String getBusinessObjIdByTask(String taskId) {
		Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
		return getBusinessObjIdByTask(task);
	}

	/**
	 * 高亮显示.
	 * <p>
	 *
	 * @param processInstanceId
	 * @return
	 */
	public List<String> highLight(String processInstanceId) {
		List<String> highLihth = new ArrayList<String>();
		List<Execution> executions = runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
		for (Execution execution : executions) {
			ExecutionEntity entity = (ExecutionEntity) runtimeService.createExecutionQuery()
					.executionId(execution.getId()).singleResult();
			highLihth.add(entity.getActivityId());
		}
		return highLihth;

	}

	@Override
	public void saveClaim(MyTaskVo myTaskVo) {
		taskService.claim(myTaskVo.getTaskId(), ResourceConfigUtils.getSessionUserName().getUserName());
	}

	@Override
	public void saveComplete(MyTaskVo myTaskVo) {
		taskService.complete(myTaskVo.getTaskId());
	}

	public void saveCompelte(OperationVo operationVo) {
		Task task = this.getTask(operationVo.getTaskId());

		if(task == null){
			throw new BusinessException("任务已经被其他人审批!");
		}
		// 构造详细审批意见
		String detailComment = CommentUtil.buildPassComment(task.getName(), ResourceConfigUtils.getCreateName(),
				operationVo.getComment());

		//把详细审批意见转换成二进制
		//detailComment  = StringUtil.strToBinstr(detailComment);

		// 添加审批意见信息
		taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);

		//验证强制答复沟通
		validForceReply(operationVo.getProcessInstanceId());

		//加入日志
		TmUserEntity user = ResourceConfigUtils.getClient().getUser();
		TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
		log.setCreateDate(new Date());
		log.setAccount(user.getUserName());
		log.setContent(operationVo.getComment());
		log.setName(user.getFullName());
		log.setProcessInstId(operationVo.getProcessInstanceId());
		log.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		log.setPositionName(ResourceConfigUtils.getCurrPosition().getPositionName());
		try {
			log.setTaskDefKey(findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
		} catch (Exception e) {
			e.printStackTrace();
		}
		log.setType(1);
		this.save(log);
		getSession().flush();
		// 设计审批操作变量，记录此操作类型为审批通过
//		taskService.setVariableLocal(operationVo.getTaskId(), "approveOpt", "pass");
//		runtimeService.setVariableLocal(task.getExecutionId(), "approveOpt", "pass");

		// 设置此任务拥有者，用于查询此职位的历史任务信息
		taskService.setOwner(operationVo.getTaskId(), ResourceConfigUtils.getCurrPosition().getPositionCode());

		//设置变量
		Map<String, Object> variable = new HashMap<>();
		variable.put("approveOpt", WorkFlowGlobals.OPT_PASS);

		//如果是会签节点，保存当前节点当时的persons变量，在第一个会签节点完成就保存
		if(this.isHuiQianNode(log.getTaskDefKey())) {
			if(taskService.getVariable(operationVo.getTaskId(), "persons" + log.getTaskDefKey()) == null) {
				taskService.setVariable(operationVo.getTaskId(),"persons" + log.getTaskDefKey(),
						taskService.getVariable(operationVo.getTaskId(),"persons"));
			}
		}

		// 完成任务
		TaJumpNodeEntity jumpNodeEntity = this.findTaJumpNodeEntity(log.getTaskDefKey(), operationVo.getProcessInstanceId());
		if(jumpNodeEntity != null) { //指定节点跳转
			//还原当时指定节点的可以驳回的节点信息
			taskService.setVariable(operationVo.getTaskId(), "backTaskIds",
					taskService.getVariable(operationVo.getTaskId(), "backTaskIds_returnThisNode"));
			this.goProcessTaskNode(operationVo.getTaskId(), jumpNodeEntity.getSrcTaskKey(), variable);
			this.delete(jumpNodeEntity);
		} else {
			taskService.complete(operationVo.getTaskId(),variable);
		}

		// 判断是否是最后一个任务节点
		if (this.isLastTask(operationVo.getProcessInstanceId())) {
			// 更新业务对象为已完成状态
			taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(
					operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_COMPLETED);
		}
	}

	/**
	 * 验证流程是否需要强制答复沟通
	 * @param processInstanceId
	 */
	private void validForceReply(String processInstanceId) {
		String sql = "SELECT cc.* FROM ta_communicate c " +
				"       LEFT JOIN ta_communicate_content cc ON c.id = cc.ta_communicate_id " +
				" WHERE cc.force_reply_flag = 'Y' AND c.process_instance_id = ?";
		List <TaCommunicateContentEntity> entityList = this.findBySql(TaCommunicateContentEntity.class, sql, processInstanceId);
		if(CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
			String errMsg = entityList.get(0).getCirculationName() + ",未答复沟通。";
			throw new BusinessException(errMsg);
		}
	}

	public boolean isHuiQianNode(String taskDefinitionKey) {
		TaProcessNodeEntity nodeEntity = taBaseBusinessObjService.findUniqueByProperty(TaProcessNodeEntity.class,
				"processNodeCode", taskDefinitionKey);
		if(nodeEntity != null && nodeEntity.getSign() != null && nodeEntity.getSign() == 1) {
			return true;
		}
		return false;
	}
    @Override
	public boolean isLastTask(String processInstanceId) {
		List<HistoricProcessInstance> list = historyService.createHistoricProcessInstanceQuery()
							.finished()
							.processInstanceId(processInstanceId)
							.list();
		if (list != null && list.size() == 1) {
			return true;
		}
		return false;
	}

	@Override
	public boolean hasRejectNodes(String taskId, String processInstanceId) {
		List<Map<String, String>> backTaskIdlist = (List<Map<String, String>>) taskService
				.getVariable(taskId, "backTaskIds");

		if(backTaskIdlist == null || backTaskIdlist.size() == 0) {
			return false;
		}
		return true;
	}

	private List<Map<String, String>> cloneBackTaskIdlist(List<Map<String, String>> backTaskIdlist) {
		List<Map<String, String>> cloneBackTaskIdlist = new <Map<String, String>> ArrayList();
		if(CollectionUtil.listNotEmptyNotSizeZero(backTaskIdlist)) {
			for(Map<String, String> map : backTaskIdlist) {
				Map <String, String> newMap = new HashMap<String, String>();
				BeanUtils.copyProperties(map, newMap);
				cloneBackTaskIdlist.add(newMap);
			}
		}
		return cloneBackTaskIdlist;
	}

	@SuppressWarnings("unchecked")
	public void saveReject(OperationVo operationVo) {
		// 查询待驳回列表数据
		List<Map<String, String>> backTaskIdlist = (List<Map<String, String>>) taskService
				.getVariable(operationVo.getTaskId(), "backTaskIds");

		Task task = this.getTask(operationVo.getTaskId());

		if (backTaskIdlist == null || backTaskIdlist.size() == 0) { // 不存在驳回列表
			throw new BusinessException("前面任务节点，都没有配置驳回，不能进行驳回上一级操作");
		}

		// 构造详细审批意见
		String detailComment = CommentUtil.buildRejectPreComment(task.getName(), ResourceConfigUtils.getCreateName(),
				operationVo.getComment());

		// 添加审批意见信息
		taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
		//加入日志
		TmUserEntity user = ResourceConfigUtils.getClient().getUser();
		TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
		log.setCreateDate(new Date());
		log.setAccount(user.getUserName());
		log.setContent(operationVo.getComment());
		log.setName(user.getFullName());
		log.setProcessInstId(operationVo.getProcessInstanceId());
		log.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		log.setPositionName(ResourceConfigUtils.getCurrPosition().getPositionName());

		try {
			log.setTaskDefKey(findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
		} catch (Exception e) {
			e.printStackTrace();
		}
		log.setType(2);
		this.save(log);

		//如果目标驳回节点时会签节点,设置persons变量为当时保存的变量数据
		if(this.isHuiQianNode(operationVo.getTaskDefKey())) {
			taskService.setVariable(operationVo.getTaskId(),
					"persons", taskService.getVariable(operationVo.getTaskId(),"persons" + operationVo.getTaskDefKey()));
		}

		//保存驳回记录
		taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId());

		// 设置此任务拥有者，用于查询此职位的历史任务信息
		taskService.setOwner(operationVo.getTaskId(), ResourceConfigUtils.getCurrPosition().getPositionCode());

		// 驳回目标节点任务key
		//String targetTaskKey = backTaskIdlist.get(backTaskIdlist.size() - 1).get("id");
		String targetTaskKey = operationVo.getTaskDefKey();

		//移除目标节点
		//backTaskIdlist.remove(backTaskIdlist.size() -1);
		int count = 0;
		for(int i = 0;i< backTaskIdlist.size();i++){
			Map<String,String> node = backTaskIdlist.get(i);
			if(node.get("id").equals(targetTaskKey)){
				count = i;
				break;
			}
		}

		List<Map<String, String>> _backTaskIdlist = new ArrayList<Map<String, String>>();
		for(int index = count;index < backTaskIdlist.size();index ++){
			_backTaskIdlist.add(backTaskIdlist.get(index));
		}
		backTaskIdlist.removeAll(_backTaskIdlist);

		//保存指定节点跳转信息
		if(StringUtils.isNotBlank(targetTaskKey) && StringUtil.isNotBlank(operationVo.getReturnThisNode())
				&& "Y".equals(operationVo.getReturnThisNode())) {
			//保存当时审批节点的可以驳回的节点信息
			taskService.setVariable(operationVo.getTaskId(), "backTaskIds_returnThisNode", taskService
					.getVariable(operationVo.getTaskId(), "backTaskIds"));
			this.saveTaJumpNodeEntity(log.getTaskDefKey(), targetTaskKey, operationVo.getProcessInstanceId());
		}

		taskService.setVariable(operationVo.getTaskId(), "backTaskIds", backTaskIdlist);
		//传递驳回上一人标识
		Map<String, Object> variable = new HashMap<>();
		variable.put("approveOpt", WorkFlowGlobals.OPT_REJECT_PRE);

		// 完成任务
		this.goProcessTaskNode(operationVo.getTaskId(), targetTaskKey, variable);
	}

	/**
	 * 保存指定节点跳转信息
	 * @param srcTaskKey
	 * @param targetTaskKey
	 * @param processInstanceId
	 */
	private void saveTaJumpNodeEntity(String srcTaskKey, String targetTaskKey, String processInstanceId) {
		TaJumpNodeEntity entity = new TaJumpNodeEntity();
		entity.setProcessInstanceId(processInstanceId);
		entity.setSrcTaskKey(srcTaskKey);
		entity.setTargetTaskKey(targetTaskKey);
		this.save(entity);
	}

	/**
	 * 查询指定节点跳转信息
	 * @param targetTaskKey
	 * @param processInstanceId
	 * @return
	 */
	private TaJumpNodeEntity findTaJumpNodeEntity(String targetTaskKey, String processInstanceId) {
		String hql = "from TaJumpNodeEntity e where e.targetTaskKey = ? AND e.processInstanceId = ?";
		List <TaJumpNodeEntity> list = this.findByHql(hql, targetTaskKey, processInstanceId);
		//判断是否是最后一个会签节点
		boolean isLastHuiQianNode = this.isLastHuiQianNode(targetTaskKey, processInstanceId);

		if(CollectionUtil.listNotEmptyNotSizeZero(list) && isLastHuiQianNode) {
			return list.get(0);
		}
		return null;
	}

	/**
	 * 判断是否是最后一个会签节点
	 * @param targetTaskKey
	 * @param processInstanceId
	 * @return
	 */
	private boolean isLastHuiQianNode(String targetTaskKey, String processInstanceId) {
		//判断是否是最后一个会签节点
		boolean isLastHuiQianNode = true;
		if(this.isHuiQianNode(targetTaskKey)) {
			String sql = "SELECT COUNT(*) AS countnum FROM act_ru_task t WHERE t.proc_inst_id_ = ?";
			Long countnum = this.getCountForJdbcParam(sql, processInstanceId);
			if(countnum > 1) {
				isLastHuiQianNode = false;
			}
		}
		return isLastHuiQianNode;
	}

	public void saveRejectToApply(OperationVo operationVo) {
		Task task = this.getTask(operationVo.getTaskId());

		// 构造详细审批意见
		String detailComment = CommentUtil.buildRejectApplyComment(task.getName(), ResourceConfigUtils.getCreateName(),
				operationVo.getComment());

		// 添加审批意见信息
		taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
		//加入日志
		TmUserEntity user = ResourceConfigUtils.getClient().getUser();
		TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
		log.setCreateDate(new Date());
		log.setAccount(user.getUserName());
		log.setContent(operationVo.getComment());
		log.setName(user.getFullName());
		log.setProcessInstId(operationVo.getProcessInstanceId());
		log.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		log.setPositionName(ResourceConfigUtils.getCurrPosition().getPositionName());
		try {
			log.setTaskDefKey(findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
		} catch (Exception e) {
			e.printStackTrace();
		}
		log.setType(2);
		this.save(log);
		// 设置此任务拥有者，用于查询此职位的历史任务信息
		taskService.setOwner(operationVo.getTaskId(), ResourceConfigUtils.getCurrPosition().getPositionCode());

		//保存驳回记录
		taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId());

		String USER_SELECT_TASK_NODE = "end";

		// 跳转到发起人节点
		// TODO获取自定义变量进行设值
		Map<String, Object> variable = new HashMap<String, Object>();
		variable.put("aborts", WorkFlowGlobals.BPM_KEY_ABORT);
		this.goProcessTaskNode(operationVo.getTaskId(), USER_SELECT_TASK_NODE, variable);

//		runtimeService.setVariableLocal(task.getExecutionId(), WorkFlowGlobals.BPM_KEY_ABORT, true);
		// 终止流程
//		runtimeService.suspendProcessInstanceById(operationVo.getProcessInstanceId());

		// 更新业务对象状态为驳回状态
		taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(
				operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_REJECT);


	}

	public void saveRejectToApply(OperationVo operationVo,String positionId) {
		Task task = this.getTask(operationVo.getTaskId());
		//用户信息
		UserInfoEntity userInfoEntity = tmUserService.findUserInfoEntityByPosId(positionId);
		String createName = StringUtil.isNotEmpty(userInfoEntity) ? userInfoEntity
				.getRealName() + "(" + userInfoEntity.getPosName() + ")"
				: "";
		// 构造详细审批意见
		String detailComment = CommentUtil.buildRejectApplyComment(task.getName(), createName,
				operationVo.getComment());

		// 添加审批意见信息
		taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
		//加入日志
		TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
		log.setCreateDate(new Date());
		log.setAccount(userInfoEntity.getUserName());
		log.setContent(operationVo.getComment());
		log.setName(userInfoEntity.getRealName());
		log.setProcessInstId(operationVo.getProcessInstanceId());
		log.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		log.setPositionName(ResourceConfigUtils.getCurrPosition().getPositionName());
		try {
			log.setTaskDefKey(findTaskById(operationVo.getTaskId()).getTaskDefinitionKey());
		} catch (Exception e) {
			e.printStackTrace();
		}
		log.setType(2);
		this.save(log);
		// 设置此任务拥有者，用于查询此职位的历史任务信息
		taskService.setOwner(operationVo.getTaskId(), userInfoEntity.getPosCode());

		//保存驳回记录
		taRejectRecordService.saveTaRejectRecord(operationVo.getProcessInstanceId(),positionId);

		String USER_SELECT_TASK_NODE = "end";

		// 跳转到发起人节点
		// TODO获取自定义变量进行设值
		Map<String, Object> variable = new HashMap<String, Object>();
		variable.put("aborts", WorkFlowGlobals.BPM_KEY_ABORT);
		this.goProcessTaskNode(operationVo.getTaskId(), USER_SELECT_TASK_NODE, variable);
		// 更新业务对象状态为驳回状态
		taBaseBusinessObjService.updateBaseBusinessObjRuntimeStatusByProcessInstanceId(
				operationVo.getProcessInstanceId(), WorkFlowGlobals.RUNTIME_STATUS_REJECT);
	}

	@Override
	public void saveRead(OperationVo operationVo) {
		TaRejectReadEntity entity = new TaRejectReadEntity();
		entity.setProcessInstanceId(operationVo.getProcessInstanceId());
		this.save(entity);
	}

	@Override
	public List<HistoryTaskVo> findMyHistoryTaskList(HistoryTaskVo historyTaskVo, Page page) {
		String orgCodes = StringUtil.getInSqlStr(historyTaskVo.getOrgCodes());
		historyTaskVo.setOrgCodes(orgCodes);

		List<HistoryTaskVo> historyTaskVoList = taTaskDao.findMyHistoryTaskList(historyTaskVo, page);
		calSpendTimes(historyTaskVoList);
		return historyTaskVoList;
	}

	/**
	 * 计算耗时.
	 * <p>
	 *
	 * @param historyTaskVoList
	 */
	private void calSpendTimes(List<HistoryTaskVo> historyTaskVoList) {
		if (historyTaskVoList != null) {
			for (HistoryTaskVo vo : historyTaskVoList) {
				vo.setSpendTimes(DateUtils.calSpendTimes(vo.getStartTime(), vo.getEndTime()));
			}
		}
	}

	@Override
	public String getProcessInstanceId(String taskId) {
		Task task = this.getTask(taskId);
		if (task == null) {
			List<HistoricTaskInstance> hiTaskList = historyService.createHistoricTaskInstanceQuery().taskId(taskId)
					.list();
			if (hiTaskList != null && hiTaskList.size() > 0) {
				return hiTaskList.get(0).getProcessInstanceId();
			}
			throw new BusinessException("任务ID（taskId）:" + taskId + "不存在");
		}
		return task.getProcessInstanceId();
	}

	@Override
	public List<HistoryTaskVo> findProcessInstanceTaskHistoryList(HistoryTaskVo historyTaskVo, Page page) {
		String processInstanceId = historyTaskVo.getProcessInstanceId();

		if (StringUtils.isBlank(processInstanceId)) {
			throw new BusinessException("流程实例ID（processInstanceId）为空");
		}

		// 获取流程实例的历史任务列表
		List<HistoricTaskInstance> historicTaskInstanceList = historyService.createHistoricTaskInstanceQuery()
				.processInstanceId(processInstanceId).list();

		// 转换entity为Vo
		List<HistoryTaskVo> voList = Lists.transform(historicTaskInstanceList,
				new HistoricTaskInstanceToHistoryTaskVo());

		return voList;
	}

	@Override
	public String getTaskBusinessForm(String taskId) {
		BusinessFormVo vo = taTaskDao.getBusinessForm(taskId);
		if(vo.getModelandview() == null) {
			return null;
		}
		return vo.getModelandview() + "&businessObjId=" + vo.getBusinessObjId();
	}

	@Override
	public String getProcessInstanceBusinessForm(String processInstanceId) {
		BusinessFormVo vo = taTaskDao.getBusinessFormByProcessInstanceId(processInstanceId);
		if(vo.getModelandview() == null) {
			return null;
		}
		return vo.getModelandview() + "&businessObjId=" + vo.getBusinessObjId();
	}

	@Override
	public List<CommentVo> findActHiCommentEntity(String processInstanceId) {
		List<CommentVo> voList = taTaskDao.findProcessInstanceCommentList(processInstanceId, null);
		for (CommentVo vo : voList) {
			List<TaAttachmentVo> list = taAttachmentService.findAttachmentList(vo.getTaskId());
			vo.setFullMsg(this.getFullMsg(vo.getBlobMsg()));
			vo.setAttachmentList(list);
		}
		return voList;
	}

	private String getFullMsg(Blob blob){
		String result = "";
		InputStream in = null;
		BufferedReader br = null;
		try {
			in = blob.getBinaryStream();
			br = new BufferedReader(new InputStreamReader(in));
			String str = "";
			while((str = br.readLine()) != null){
				result += str;
			}
		} catch (SQLException | IOException e) {
			e.printStackTrace();
		}finally{
			try {
				br.close();
				in.close();
			} catch (Exception e2) {
				e2.printStackTrace();
			}
		}
		return result;
	}
	@Override
	public List<CommentVo> findActHiCommentByBusinessKey(String businessKey){
		List<CommentVo> result = taTaskDao.findProcessInstanceCommentByBusinessKey(businessKey);
		for (CommentVo vo : result) {
			List<TaAttachmentVo> list = taAttachmentService.findAttachmentList(vo.getTaskId());
			vo.setAttachmentList(list);
		}
		return result;
	}
	@Override
	public List<TaAttachmentEntity> findAttachmentList(String taskId) {
		List<TaAttachmentEntity> list = this.findByProperty(TaAttachmentEntity.class, "taskId", taskId);
		return list;
	}

	@Override
	public void reassign(MyTaskVo myTaskVo, String reassignComment, String reassignPositionCode) {
		String taskId = myTaskVo.getTaskId();
		Task task = this.getTask(taskId);
		TmPositionVo positionVo = ResourceConfigUtils.getCurrPosition();
		taskService.addComment(taskId, task.getProcessInstanceId(),
				CommentUtil.buildReassignComment(task.getName(), ResourceConfigUtils.getCreateName(), reassignComment));
		taskService.setVariableLocal(taskId, "approveOpt", "reassign");
		taskService.setOwner(taskId, positionVo.getPositionCode());
		taskService.setAssignee(taskId, reassignPositionCode);
	}

	public void complete(String taskId, Map<String, Object> map) {
		try {
			String businessObjId = this.getBusinessObjIdByTask(taskId);
			// 获取指定跳转节点
			String USER_SELECT_TASK_NODE = OConvertUtils.getString(map.get(WorkFlowGlobals.USER_SELECT_TASK_NODE));
			// 跳转到指定流程节点
			this.goProcessTaskNode(taskId, USER_SELECT_TASK_NODE, map);

			// 根据businessKey判断是否流程结束
			List<HistoricProcessInstance> list = historyService.createHistoricProcessInstanceQuery().finished()
					.processInstanceBusinessKey(businessObjId).list();
			if (list != null && list.size() == 1) {
				// 流程结束 根据id修改tb_basebus的状态为结束(id即为businessKey)
				TaRuntimeStatusEntity r = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "completed");
				TaBaseBusinessObjEntity obj = this.get(TaBaseBusinessObjEntity.class, businessObjId);
				obj.setTaRuntimeStatusEntity(r);
				this.updateEntity(obj);
			}
		} catch (ActivitiException e) {
			if (e.getMessage().indexOf("no processes deployed with key") != -1) {
				// msg = "没有部署子流程!,请在流程配置中部署流程";
				// complete = false;
				e.printStackTrace();
			} else {
				// msg = "启动流程失败!,内部错误";
				// complete = false;
				e.printStackTrace();

			}
		} catch (Exception e) {
			// msg = "内部错误";
			// complete = false;
			e.printStackTrace();
		}
	}
    @Override
	public synchronized void goProcessTaskNode(String taskId, String activityId, Map<String, Object> variables) {
		try {
			// 查找所有并行任务节点，同时驳回
			List<Task> taskList = findTaskListByKey(findProcessInstanceByTaskId(taskId).getId(),
					findTaskById(taskId).getTaskDefinitionKey());
			for (Task task : taskList) {
				commitProcess(task.getId(), variables, activityId);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	/**
	 * 提交任务.
	 * <p>
	 *
	 * @param taskId
	 *            任务ID
	 * @param variables
	 *            流程变量
	 *            任务key
	 * @throws Exception
	 */
	private void commitProcess(String taskId, Map<String, Object> variables, String taskDefinitionKey)
			throws Exception {
		// 跳转节点为空，默认提交操作
		if (OConvertUtils.isEmpty(taskDefinitionKey)) {
			taskService.complete(taskId, variables);
		} else {// 流程转向操作
			turnTransition(taskId, taskDefinitionKey, variables);
		}
	}

	/**
	 * 当前任务跳转到指定的任务中.
	 * <p>
	 *
	 * @param taskId
	 *            任务id
	 * @param taskDefinitionKey
	 *            要跳转到的任务定义Key
	 * @param variables
	 *            流程变量
	 * @throws Exception
	 */
	private void turnTransition(String taskId, String taskDefinitionKey, Map<String, Object> variables)
			throws Exception {
		// 当前节点
		ActivityImpl currActivity = findActivitiImpl(taskId, null);
		// 清空当前流向
		List<PvmTransition> oriPvmTransitionList = clearTransition(currActivity);

		// 创建新流向
		TransitionImpl newTransition = currActivity.createOutgoingTransition();
		// 目标节点
		ActivityImpl pointActivity = findActivitiImpl(taskId, taskDefinitionKey);
		// 设置新流向的目标节点
		newTransition.setDestination(pointActivity);

		try {
			// 执行转向任务
			taskService.complete(taskId, variables);
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
			// 删除目标节点新流入
			pointActivity.getIncomingTransitions().remove(newTransition);
			// 还原以前流向
			restoreTransition(currActivity, oriPvmTransitionList);
		}

	}

	private List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
		// 存储当前节点所有流向临时变量
		List<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
		// 获取当前节点所有流向，存储到临时变量，然后清空
		List<PvmTransition> pvmTransitionList = activityImpl.getOutgoingTransitions();
		for (PvmTransition pvmTransition : pvmTransitionList) {
			oriPvmTransitionList.add(pvmTransition);
		}
		pvmTransitionList.clear();

		return oriPvmTransitionList;
	}

	private void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
		// 清空现有流向
		List<PvmTransition> pvmTransitionList = activityImpl.getOutgoingTransitions();
		pvmTransitionList.clear();
		// 还原以前流向
		for (PvmTransition pvmTransition : oriPvmTransitionList) {
			pvmTransitionList.add(pvmTransition);
		}
	}

	public ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) throws Exception {
		// 取得流程定义
		ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
				.getDeployedProcessDefinition(findTaskById(taskId).getProcessDefinitionId());

		if (processDefinition == null) {
			throw new Exception("流程定义未找到!");
		}

		return processDefinition;
	}

	private ActivityImpl findActivitiImpl(String taskId, String activityId) throws Exception {
		// 取得流程定义
		ProcessDefinitionEntity processDefinition = findProcessDefinitionEntityByTaskId(taskId);

		// 获取当前活动节点ID
		if (StringUtils.isEmpty(activityId)) {
			activityId = findTaskById(taskId).getTaskDefinitionKey();
		}

		// 根据流程定义，获取该流程实例的结束节点
		if (activityId.toUpperCase().equals("END")) {
			for (ActivityImpl activityImpl : processDefinition.getActivities()) {
				List<PvmTransition> pvmTransitionList = activityImpl.getOutgoingTransitions();
				if (pvmTransitionList.isEmpty()) {
					return activityImpl;
				}
			}
		}

		// 根据节点ID，获取对应的活动节点
		ActivityImpl activityImpl = ((ProcessDefinitionImpl) processDefinition).findActivity(activityId);

		return activityImpl;
	}

	private List<Task> findTaskListByKey(String processInstanceId, String key) {
		return taskService.createTaskQuery().processInstanceId(processInstanceId).taskDefinitionKey(key).list();
	}

	public ProcessInstance findProcessInstanceByTaskId(String taskId) throws Exception {
		// 找到流程实例
		ProcessInstance processInstance = runtimeService.createProcessInstanceQuery()
				.processInstanceId(findTaskById(taskId).getProcessInstanceId()).singleResult();
		if (processInstance == null) {
			throw new Exception("流程实例未找到!");
		}
		return processInstance;
	}

	private TaskEntity findTaskById(String taskId) throws Exception {
		TaskEntity task = (TaskEntity) taskService.createTaskQuery().taskId(taskId).singleResult();
		if (task == null) {
			throw new Exception("任务实例未找到!");
		}
		return task;
	}

	@Override
	public List<MyTaskVo> findMyRejectTaskList(MyTaskVo myTaskVo, Page page) {
		List <MyTaskVo> voList = taTaskDao.findMyRejectTaskList(myTaskVo, page);
		return voList;
	}

	@Override
	public void findProcessBasicInfoByProcinstId(MyTaskVo myTaskVo, HttpServletRequest request) {
		//流程基本信息获取
		MyTaskVo processVo = taTaskDao.findProcessBasicInfoByProcinstId(myTaskVo.getProcessInstanceId());

		request.setAttribute("processVo", processVo);
	}

	@Override
	public void findAttachmentListByProcinstId(String processInstanceId,HttpServletRequest request) {
		//获取bussinessKey
		ActHiProcinstEntity actHiProcinstEntity = this.findUniqueByProperty(ActHiProcinstEntity.class, "procInstId", processInstanceId);
		List<TbAttachmentQueryEntity> entity = this.findByProperty(TbAttachmentQueryEntity.class, "businessKey", actHiProcinstEntity.getBusinessKey());

		request.setAttribute("attachment", entity);
	}

	@Override
	public void findKeyIndicators(MyTaskVo myTaskVo, HttpServletRequest request) {
		ActHiProcinstEntity actHiProcinstEntity = this.findUniqueByProperty(ActHiProcinstEntity.class, "procInstId", myTaskVo.getProcessInstanceId());
		ActReProcdefEntity actReProcdefEntity = this.get(ActReProcdefEntity.class, actHiProcinstEntity.getProcDefId());
		//获取流程key
		String processKey = actReProcdefEntity.getKey();
		//获取businessKey
		String businessKey = actHiProcinstEntity.getBusinessKey();

		//获取配置
		TaKeyIndicatorsConfigEntity tki = this.findUniqueByProperty(TaKeyIndicatorsConfigEntity.class, "processKey", processKey);
		if(tki == null){
			request.setAttribute("noKey", true);
		}else{
			request.setAttribute("noKey", false);
			//处理表头
			List<String> head = new ArrayList<String>();
			String[] title = tki.getTitle().split(",");
			for(String t : title){
				head.add(t);
			}
			request.setAttribute("head", head);

			//获取数据
			TaKeyIndicators service = (TaKeyIndicators) ApplicationContextUtils.getContext().getBean(tki.getServiceName());
			List<Map<String,Object>> data = service.findKeyIndicators(businessKey);

			//组装数据
			List<Object> returnList = new ArrayList<Object>();
			String [] field = tki.getField().split(",");
			for(Map<String,Object> map : data){
				List<TaKeyIndicatorsVo> middleList = new ArrayList<TaKeyIndicatorsVo>();
				for(String key : field){
					TaKeyIndicatorsVo value = new TaKeyIndicatorsVo();
					value .setValue(String.valueOf(map.get(key)));
					middleList.add(value);
				}
				returnList.add(middleList);
			}

			request.setAttribute("returnList", returnList);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public void findRejectNode(String taskId, String processInstanceId, HttpServletRequest request) {
		List<Map<String, String>> backTaskIdlist = (List<Map<String, String>>) taskService.getVariable(taskId, "backTaskIds");
		request.setAttribute("processNode", backTaskIdlist);
	}
	@Override
	public List<Map<String, String>> findRejectNode(String taskId,String processInstanceId){
		List<Map<String, String>> backTaskIdlist = (List<Map<String, String>>)taskService.getVariable(taskId, "backTaskIds");
		return backTaskIdlist;
	}

	/**
	 * 获取审批数据信息
	 * @param myTaskVo
	 * @return
	 */
	public List <TaProcessApprovalLogVo> findApprovalLogs2(MyTaskVo myTaskVo) {
		HistoricProcessInstance processInstance = historyService.createHistoricProcessInstanceQuery()
				.processInstanceId(myTaskVo.getProcessInstanceId()).singleResult();
		//获取已审批数据
		List<TaProcessApprovalLogVo> approvedList = taTaskDao.findLog(myTaskVo.getProcessInstanceId());

		//审批正准备审批数据
		List<TaProcessApprovalLogVo> runtimeApprovalList = this.findRuntimeApprovalList(processInstance);

		//获取将要审批的数据
		List<TaProcessApprovalLogVo> pendingApproveList = this.findPendingApprovalList(processInstance, runtimeApprovalList);

		//最终数据
		List <TaProcessApprovalLogVo> resultList = new ArrayList<TaProcessApprovalLogVo>();

		//把3部分数据加起来
		if(CollectionUtil.listNotEmptyNotSizeZero(approvedList)) {
			resultList.addAll(approvedList);
		}
		if(CollectionUtil.listNotEmptyNotSizeZero(runtimeApprovalList)) {
			resultList.addAll(runtimeApprovalList);
		}
		if(CollectionUtil.listNotEmptyNotSizeZero(pendingApproveList)) {
			resultList.addAll(pendingApproveList);

			//设置审批意见类型
			setApprovalLogType(pendingApproveList, processInstance);
		}

		return resultList;
	}

	/**
	 * 设置审批类型， 例如：（会签，待审批）
	 * @param processInstance
	 */
	private void setApprovalLogType(List <TaProcessApprovalLogVo> resultList, HistoricProcessInstance processInstance) {
		BpmnModel model = repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
		if(model != null) {
			Collection<FlowElement> flowElements = model.getMainProcess().getFlowElements();

			//把用户任务信息放入Map中
			Map <String, String> typeMap = new HashMap<String, String>();
			for(FlowElement e : flowElements) {
				if(e instanceof UserTask) {
					UserTask userTask = (UserTask)e;
					MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = userTask
							.getLoopCharacteristics(); //如果是会签则此值不会空
					if(multiInstanceLoopCharacteristics != null) {
						typeMap.put(e.getId(), "会签");
					} else {
						typeMap.put(e.getId(), "待审批");
					}
				}
			}

			for(TaProcessApprovalLogVo result : resultList) {
				if(typeMap.containsKey(result.getTaskDefKey())) {
					result.setType(typeMap.get(result.getTaskDefKey()));
				}
			}
		}
	}

	/**
	 * 获取下一个节点
	 * @param taskDefKey 当前审批节点key
	 * @param processInstanceId
	 * @return
	 */
	private String getJumpToNodeTaskDefKey(String taskDefKey, String processInstanceId) {
		//获取指定跳转到指定节点定义Key
		String hql = "from TaJumpNodeEntity e where e.targetTaskKey = ? AND e.processInstanceId = ?";
		List <TaJumpNodeEntity> list = this.findByHql(hql, taskDefKey, processInstanceId);
		if(CollectionUtil.listNotEmptyNotSizeZero(list)) {
			return list.get(0).getSrcTaskKey();
		}
		return null;
	}

	/**
	 * 获取当前待审批节点信息
	 * @param processInstance
	 * @return
	 */
	private List <TaProcessApprovalLogVo> findRuntimeApprovalList(HistoricProcessInstance processInstance) {
		List <TaProcessApprovalLogVo> voList = taTaskDao.findRuntimeApprovalList(processInstance.getId());

		if(CollectionUtil.listNotEmptyNotSizeZero(voList)) {
			for(TaProcessApprovalLogVo vo : voList) {
				vo.setType("待审批");
			}
		}

		return voList;
	}

	/**
	 * 获取将要进行审批的节点信息
	 * @param processInstance
	 * @return
	 */
	private List <TaProcessApprovalLogVo> findPendingApprovalList(HistoricProcessInstance processInstance,
																  List<TaProcessApprovalLogVo> runtimeApprovalList) {
		if(CollectionUtil.listEmpty(runtimeApprovalList)) {
			//如果待审批没有数据则直接返回
			return null;
		}

		//获取流程定义实体
		ProcessDefinitionEntity def = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
				.getDeployedProcessDefinition(processInstance.getProcessDefinitionId());

		//获取待审批定义Key
		String taskDefKey = runtimeApprovalList.get(0).getTaskDefKey();

		//直接跳转至的任务节点
		String jumpTaskDefKey = this.getJumpToNodeTaskDefKey(taskDefKey, processInstance.getId());

		List <TaProcessApprovalLogVo> approvalLogVoList  = new ArrayList<TaProcessApprovalLogVo>();

		//如果需要直接跳转的节点存在，则把该节点加入审批列表中
		if(StringUtils.isNotBlank(jumpTaskDefKey)) {
			ActivityImpl activityImpl = def.findActivity(jumpTaskDefKey);
			TaProcessApprovalLogVo approvalLogVo = new TaProcessApprovalLogVo();
			approvalLogVo.setRoleName((String)activityImpl.getProperties().get("name"));
			approvalLogVo.setType("待审批");
			approvalLogVo.setTaskDefKey(activityImpl.getId());
			approvalLogVoList.add(approvalLogVo);
		}

		//当前显示节点定义Key
		String currentTaskDefKey = StringUtils.isNotBlank(jumpTaskDefKey) ? jumpTaskDefKey : taskDefKey;
        int count=0;
		while (!"end".equals(currentTaskDefKey)) {
			ActivityImpl activityImpl = def.findActivity(currentTaskDefKey);

			//出线对象
			List<PvmTransition> outTransitions = activityImpl.getOutgoingTransitions();

			for (PvmTransition tr : outTransitions) {
				PvmActivity ac = tr.getDestination(); // 获取线路的终点节点

				if(!"end".equals(ac.getId())) {
					if(!"exclusiveGateway".equals(ac.getProperty("type"))) {
						TaProcessApprovalLogVo approvalLogVo = new TaProcessApprovalLogVo();
						approvalLogVo.setRoleName((String)ac.getProperty("name"));
						approvalLogVo.setType("待审批");
						approvalLogVo.setTaskDefKey(ac.getId());
						approvalLogVoList.add(approvalLogVo);
					}
				}

				currentTaskDefKey = ac.getId();
			}

			count++;

			if (count>30){
				break;
			}
		}

		return approvalLogVoList;
	}

	@Override
	public List<TaProcessApprovalLogVo> findApprovalLogs(MyTaskVo myTaskVo){
        List<TaProcessApprovalLogVo> approvalLogs2 = this.findApprovalLogs2(myTaskVo);
        if(taApprovalLogExtendService != null){
            approvalLogs2 = taApprovalLogExtendService.filterApproveContent(approvalLogs2,null,myTaskVo);
        }
        return approvalLogs2;
    }

	@Override
	public void findApprovalLogs(MyTaskVo myTaskVo, HttpServletRequest request) {
		List <TaProcessApprovalLogVo> yes = this.findApprovalLogs2(myTaskVo);
		if(taApprovalLogExtendService != null){
            yes = taApprovalLogExtendService.filterApproveContent(yes,request,myTaskVo);
        }
		request.setAttribute("log",yes);
	}


	@Override
	public BusinessFormVo getBusinessFormByProcessInstanceId(String processInstanceId) {
		return taTaskDao.getBusinessFormByProcessInstanceId(processInstanceId);
	}

	//获取未处理节点的key str
	private String handleNode(String processInstanceId,String taskKey) {
		//通过流程实例 获取当前任务节点
		String sql = "select task_def_key_  task_def_key from  act_ru_task where proc_inst_id_ = ?";
		List<ActRuTaskEntity> tasks = this.findBySql(ActRuTaskEntity.class, sql, processInstanceId);
		if(CollectionUtil.listEmpty(tasks)){
			return "''";
		}
		//获取所有的节点
		String allNode = " select node.* from ta_process_node node                                    "
						+" join ta_process p on p.id = node.process_id                                "
						+" join ta_process_busiobj_config conf on conf.process_id = p.id              "
						+" join ta_base_business_obj obj on obj.process_busiobj_config_id = conf.id   "
						+" join act_hi_procinst inst on inst.business_key_ = obj.id                   "
						+" where inst.proc_inst_id_ = ? order by sort asc            ";

		List<TaProcessNodeEntity> nodes = this.findBySql(TaProcessNodeEntity.class, allNode, processInstanceId);

		int count = 0;
		String nowTaskKey = tasks.get(0).getTaskDefKey();
		for(int i = 0;i < nodes.size();i++){
			if(nowTaskKey.equals(nodes.get(i).getProcessNodeCode())){
				String signSql = " select assignee_ assignee from act_ru_task task where task.proc_inst_id_ = ? and task_def_key_ = ?";
				List<ActRuTaskEntity> result = this.findBySql(ActRuTaskEntity.class, signSql, processInstanceId,taskKey);

				//如果是处于流程中的会签
				if(CollectionUtil.listNotEmptyNotSizeZero(result)){
					count = i+1;
				}else{
					count = i;//找到当前节点的 任务
				}
				break;
			}
		}

		//返回node str
		StringBuffer sb = new StringBuffer();
		for(int n = count;n < nodes.size();n++){
			sb.append("'"+nodes.get(n).getProcessNodeCode()+"',");
		}
		if(sb.length() == 0){
			return "''";
		}
		return sb.substring(0, sb.length()-1).toString();
	}

	@Override
	public void setNodeAuth(MyTaskVo myTaskVo, HttpServletRequest request) {
		if (StringUtils.isNotBlank(myTaskVo.getTaskId())) {
			Task task = this.getTask(myTaskVo.getTaskId());
			if (task != null) {
				String taskDefinitionKey = task.getTaskDefinitionKey();

				String versionkey=task.getProcessDefinitionId();  //版本号

				TaProcessNodeProEntity processNodeEntity = taProcessNodeService.getTaProcessNodeByVersionKey(versionkey,taskDefinitionKey);

				TaProcessNodeAuthProEntity taProcessNodeAuthEntity = taProcessNodeService.getTaProcessNodeAuthEntity(versionkey,processNodeEntity.getId());
				request.setAttribute("nodeAuth", new TaProcessNodeAuthVo(
						taProcessNodeAuthEntity.getBtn1(), taProcessNodeAuthEntity.getBtn2(),
						taProcessNodeAuthEntity.getBtn3(), taProcessNodeAuthEntity.getBtn4(),
						taProcessNodeAuthEntity.getBtn5(), taProcessNodeAuthEntity.getBtn6(),
						taProcessNodeAuthEntity.getBtn7(), taProcessNodeAuthEntity.getBtn8(),
						taProcessNodeAuthEntity.getBtn9(), taProcessNodeAuthEntity.getBtn10()
				));
			} else {
				request.setAttribute("nodeAuth", new TaProcessNodeAuthVo("Y", "Y", "Y", "Y",
						"Y", "Y", "Y", "Y", "Y", "Y"));
			}
		} else {
			request.setAttribute("nodeAuth", new TaProcessNodeAuthVo("Y", "Y", "Y", "Y",
					"Y", "Y", "Y", "Y", "Y", "Y"));
		}
	}
}
